/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.steps;

import cucumber.eclipse.steps.integration.ExpressionDefinition;
import cucumber.eclipse.steps.integration.ResourceHelper;
import cucumber.eclipse.steps.integration.StepDefinition;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class StorageHelper {
    private static final String OUTPUT_FOLDER = ".cucumber";
    static ResourceHelper RESOURCEHELPER = new ResourceHelper();

    public static InputStream toStream(Serializable serializable, IProgressMonitor monitor) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (ObjectOutputStream outputStream = new ObjectOutputStream(bout);){
                outputStream.writeObject(serializable);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            return new ByteArrayInputStream(bout.toByteArray());
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static <T extends Serializable> T fromStream(Class<T> type, InputStream stream, IProgressMonitor monitor) throws IOException, ClassNotFoundException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ObjectInputStream objectStream = new ObjectInputStream(stream);){
            return (T)((Serializable)type.cast(objectStream.readObject()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static IFolder getOutputFolder(IProject project) throws JavaModelException, CoreException {
        IFolder folder;
        if (!project.isOpen()) {
            throw new IllegalStateException("Project is closed");
        }
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            folder = project.getFolder("bin").getFolder(OUTPUT_FOLDER);
        } else {
            folder = project.getFolder(OUTPUT_FOLDER);
        }
        return folder;
    }

    public static void saveIntoBuildDirectory(String filename, IProject project, IProgressMonitor monitor, InputStream stream) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Saving data", (int)100);
        IFolder target = StorageHelper.getOutputFolder(project);
        StorageHelper.createFolder(target, (IProgressMonitor)subMonitor.newChild(10));
        IFile buildFile = target.getFile(filename);
        if (buildFile.exists()) {
            buildFile.setContents(stream, true, false, (IProgressMonitor)subMonitor.newChild(90));
        } else {
            buildFile.create(stream, true, (IProgressMonitor)subMonitor.newChild(90));
        }
    }

    private static void createFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        if (folder.exists()) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IContainer parent = folder.getParent();
        if (parent instanceof IFolder) {
            IFolder parentFolder = (IFolder)parent;
            StorageHelper.createFolder(parentFolder, (IProgressMonitor)subMonitor.newChild(1));
        }
        folder.create(true, true, (IProgressMonitor)subMonitor.newChild(1));
    }

    static void writeStepDefinition(StepDefinition stepDefinition, ObjectOutput out) throws IOException {
        out.writeObject(stepDefinition.getId());
        out.writeObject(stepDefinition.getLabel());
        out.writeObject(stepDefinition.getPackageName());
        out.writeObject(stepDefinition.getSourceName());
        out.writeInt(stepDefinition.getLineNumber());
        out.writeObject(stepDefinition.getExpression().getLang());
        out.writeObject(stepDefinition.getExpression().getText());
        IResource source = stepDefinition.getSource();
        if (source != null) {
            out.writeObject(source.getFullPath().toString());
        } else {
            out.writeObject(null);
        }
    }

    static StepDefinition readStepDefinition(ObjectInput in) throws ClassNotFoundException, IOException {
        String id = (String)in.readObject();
        String label = (String)in.readObject();
        String packageName = (String)in.readObject();
        String sourceName = (String)in.readObject();
        int line = in.readInt();
        String expStr = (String)in.readObject();
        String expLang = (String)in.readObject();
        String sourceRef = (String)in.readObject();
        IResource resource = RESOURCEHELPER.find(sourceRef);
        ExpressionDefinition expression = new ExpressionDefinition(expStr, expLang);
        return new StepDefinition(id, label, expression, resource, line, sourceName, packageName);
    }
}

