/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.steps;

import cucumber.eclipse.editor.steps.StepDefinitionsRepository;
import cucumber.eclipse.editor.steps.StepDefinitionsStorage;
import cucumber.eclipse.editor.util.ExtensionRegistryUtil;
import cucumber.eclipse.steps.integration.IStepDefinitionsProvider;
import cucumber.eclipse.steps.integration.StepDefinition;
import cucumber.eclipse.steps.integration.marker.MarkerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class UniversalStepDefinitionsProvider
implements IStepDefinitionsProvider {
    public static final UniversalStepDefinitionsProvider INSTANCE = new UniversalStepDefinitionsProvider();
    private StepDefinitionsStorage stepDefinitionsStorage = StepDefinitionsStorage.INSTANCE;
    private transient List<IStepDefinitionsProvider> stepDefinitionsProviders = ExtensionRegistryUtil.getStepDefinitionsProvider();
    private transient List<IProject> initializedProjects = new ArrayList<IProject>();

    private UniversalStepDefinitionsProvider() {
    }

    public Set<StepDefinition> getStepDefinitions(IProject project) throws CoreException {
        IProject[] referencedProjects;
        StepDefinitionsRepository stepDefinitionsRepository = this.stepDefinitionsStorage.getOrCreate(project, null);
        Set<StepDefinition> stepDefinitions = stepDefinitionsRepository.getAllStepDefinitions();
        IProject[] iProjectArray = referencedProjects = project.getReferencedProjects();
        int n = referencedProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject referencedProject = iProjectArray[n2];
            Set<StepDefinition> stepDefinitionsFromReferencedProject = this.getStepDefinitions(referencedProject);
            stepDefinitions.addAll(stepDefinitionsFromReferencedProject);
            ++n2;
        }
        return stepDefinitions;
    }

    public Set<IFile> getStepDefinitionsFiles(IProject project) throws CoreException {
        StepDefinitionsRepository stepDefinitionsRepository = this.stepDefinitionsStorage.getOrCreate(project, null);
        return stepDefinitionsRepository.getAllStepDefinitionsFiles();
    }

    public Set<StepDefinition> findStepDefinitions(IResource stepDefinitionResource, MarkerFactory markerFactory, IProgressMonitor monitor) throws CoreException {
        long start = System.currentTimeMillis();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("Scan steps definitions for " + stepDefinitionResource.getName()), (int)this.stepDefinitionsProviders.size());
        IProject project = stepDefinitionResource.getProject();
        StepDefinitionsRepository stepDefinitionsRepository = this.stepDefinitionsStorage.getOrCreate(project, null);
        int stepDefinitionsCounter = 0;
        for (IStepDefinitionsProvider stepDefinitionsService : this.stepDefinitionsProviders) {
            if (!stepDefinitionsService.support(project)) continue;
            Set stepDefs = stepDefinitionsService.findStepDefinitions(stepDefinitionResource, markerFactory, (IProgressMonitor)subMonitor);
            if (!stepDefs.isEmpty()) {
                stepDefinitionsCounter += stepDefs.size();
            }
            stepDefinitionsRepository.add(stepDefinitionResource, stepDefs);
        }
        return stepDefinitionsRepository.getAllStepDefinitions();
    }

    public void clean(IProject project) throws CoreException {
        StepDefinitionsRepository stepDefinitionsRepository = this.stepDefinitionsStorage.getOrCreate(project, null);
        stepDefinitionsRepository.reset();
    }

    public void persist(IProject project, IProgressMonitor monitor) throws IOException, CoreException {
        this.stepDefinitionsStorage.persist(project, monitor);
    }

    public void load(IProject project) throws CoreException {
        this.stepDefinitionsStorage.load(project, null);
        this.initializedProjects.add(project);
    }

    public boolean support(IProject project) throws CoreException {
        for (IStepDefinitionsProvider stepDefinitionsProvider : this.stepDefinitionsProviders) {
            if (!stepDefinitionsProvider.support(project)) continue;
            return true;
        }
        return false;
    }

    public boolean support(IResource resource) throws CoreException {
        for (IStepDefinitionsProvider stepDefinitionsProvider : this.stepDefinitionsProviders) {
            if (!stepDefinitionsProvider.support(resource)) continue;
            return true;
        }
        return false;
    }

    public boolean isInitialized(IProject project) {
        return this.initializedProjects.contains(project);
    }
}

