/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.wizard;

import cucumber.eclipse.editor.util.JDTUtil;
import cucumber.eclipse.editor.util.SWTUtil;
import cucumber.eclipse.editor.util.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

public class NewStepDefFileWizardPage
extends WizardPage {
    private Text m_sourceFolderText;
    private Text m_packageNameText;
    private Text m_featureNameText;
    private static final String PAGE_TITLE = "New Cucumber Step Definition File";
    private static final String PAGE_DESC = "Specify additional information about Step Definition File";
    private List<Utils.JavaElement> m_elements = null;
    private Map<String, Button> m_annotations = new HashMap<String, Button>();
    public static final String[] ANNOTATIONS = new String[]{"Given", "When", "Then", "And", "But", ""};

    public NewStepDefFileWizardPage() {
        super(PAGE_TITLE);
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESC);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        this.createTop(container);
        this.createBottom(container);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void createTop(Composite parent) {
        final Composite container = SWTUtil.createGridContainer(parent, 3);
        this.m_sourceFolderText = SWTUtil.createPathBrowserText(container, "&Source Folder:", new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewStepDefFileWizardPage.this.dialogChanged();
            }
        });
        Label label = new Label(container, 0);
        label.setText("&Package Name:");
        this.m_packageNameText = new Text(container, 2052);
        this.m_packageNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewStepDefFileWizardPage.this.dialogChanged();
            }
        });
        GridData gd = new GridData(768);
        this.m_packageNameText.setLayoutData((Object)gd);
        Button button = new Button(container, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewStepDefFileWizardPage.this.handleBrowsePackages(container.getShell());
            }
        });
        Label label1 = new Label(container, 0);
        label1.setText("&Class Name:");
        this.m_featureNameText = new Text(container, 2052);
        GridData gd1 = new GridData(768);
        this.m_featureNameText.setLayoutData((Object)gd1);
        this.m_featureNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewStepDefFileWizardPage.this.dialogChanged();
            }
        });
    }

    private void handleBrowsePackages(Shell dialogParrentShell) {
        try {
            Object[] selectedPackages;
            IResource sourceContainer = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getSourceFolder()));
            IJavaProject javaProject = JDTUtil.getJavaProject(sourceContainer.getProject().getName());
            SelectionDialog dialog = JavaUI.createPackageDialog((Shell)dialogParrentShell, (IJavaProject)javaProject, (int)0);
            dialog.setTitle("Package Selection");
            dialog.setMessage("&Choose A Package:");
            if (dialog.open() == 0 && (selectedPackages = dialog.getResult()).length == 1) {
                this.m_packageNameText.setText(((IPackageFragment)selectedPackages[0]).getElementName());
            }
        }
        catch (JavaModelException localJavaModelException) {
            this.updateStatus("Failed To List Packages.");
        }
    }

    private void initialize() {
        this.m_elements = Utils.getSelectedJavaElements();
        if (this.m_elements.size() > 0) {
            Utils.JavaElement sel = this.m_elements.get(0);
            if (sel.sourceFolder != null) {
                this.m_sourceFolderText.setText(sel.sourceFolder);
            }
            if (sel.getPackageName() != null) {
                this.m_packageNameText.setText(sel.getPackageName());
            }
            if (sel.getClassName() != null) {
                this.m_featureNameText.setText(sel.getClassName());
            }
        }
    }

    public List<Utils.JavaElement> getJavaElements() {
        return this.m_elements;
    }

    private void dialogChanged() {
        String ext;
        IResource container = null;
        IProject project = null;
        String className = "";
        String projectName = "";
        String sourceText = "";
        try {
            className = this.getClassName();
            container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getSourceFolder()));
            project = container.getProject();
            sourceText = this.m_sourceFolderText.getText();
            if (project != null) {
                projectName = project.getName();
            }
            if (project == null && ("".equals(projectName) || projectName.length() == 0)) {
                this.updateStatus("The Source Folder of an existing project must be specified.");
                return;
            }
            if (!sourceText.endsWith("/src/main/java") && !sourceText.endsWith("/src/test/java")) {
                this.updateStatus("Source Folder Must Contain '/src/main/java' or '/src/test/java'");
                return;
            }
        }
        catch (Exception ex) {
            this.updateStatus("Source Folder is not a Java project.");
            return;
        }
        if (this.getPackageName().length() == 0) {
            this.updateStatus("The Package Must Be Specified");
            return;
        }
        if (container != null && !container.isAccessible()) {
            this.updateStatus("Project Must Be Writable");
            return;
        }
        if (className.length() == 0) {
            this.updateStatus("Class Name Must Be Specified");
            return;
        }
        if (className.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus("Class Name Must Be Valid");
            return;
        }
        int dotLoc = className.lastIndexOf(46);
        if (dotLoc != -1 && !(ext = className.substring(dotLoc + 1)).equalsIgnoreCase("java")) {
            this.updateStatus("File extension must be \"java\"");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private void createBottom(Composite parent) {
        Group g = new Group(parent, 64);
        g.setText("Cucumber Annotations");
        GridData gd = new GridData(768);
        g.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        g.setLayout((Layout)layout);
        layout.numColumns = 3;
        String[] stringArray = ANNOTATIONS;
        int n = ANNOTATIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            if ("".equals(label)) {
                new Label((Composite)g, 0);
            } else {
                Button b = new Button((Composite)g, "".equals(label) ? 0 : 32);
                this.m_annotations.put(label, b);
                b.setText("@" + label);
            }
            ++n2;
        }
    }

    public String getSourceFolder() {
        return this.m_sourceFolderText.getText();
    }

    public String getPackageName() {
        return this.m_packageNameText.getText();
    }

    public String getClassName() {
        return this.m_featureNameText.getText();
    }

    public boolean containsAnnotation(String annotation) {
        Button b = this.m_annotations.get(annotation);
        return b.getSelection();
    }

    public String getPackage() {
        return this.m_packageNameText.getText();
    }
}

