/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.analytics;

import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.StringConsoleOption;
import com.kms.katalon.execution.integration.ReportIntegrationContribution;
import com.kms.katalon.execution.integration.ReportIntegrationFactory;
import com.kms.katalon.integration.analytics.constants.IntegrationAnalyticsMessages;
import com.kms.katalon.integration.analytics.report.AnalyticsReportIntegration;
import com.kms.katalon.logging.LogUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class AnalyticsCommandFactory {
    private static final String PREFIX = "-testOps.";

    public static List<String> getTestopsCommandList(List<String> arguments) {
        if (arguments == null || arguments.isEmpty() || arguments.stream().noneMatch(arg -> arg.startsWith(PREFIX))) {
            return null;
        }
        List<String> testOpsCommand = arguments.stream().filter(arg -> arg.startsWith(PREFIX)).collect(Collectors.toList());
        return testOpsCommand;
    }

    public static List<ConsoleOption<?>> createTestopsConsoleOptionList(List<String> testOpsCommand) {
        if (testOpsCommand == null || testOpsCommand.isEmpty()) {
            return null;
        }
        List<String> testOpsArguments = testOpsCommand.stream().map(arg -> {
            String[] splits = arg.split("=");
            if (splits.length > 1) {
                return splits[0].substring(1);
            }
            return "";
        }).filter(arg -> StringUtils.isNotBlank((CharSequence)arg) && AnalyticsCommandFactory.ensureLegalOption(arg)).collect(Collectors.toList());
        if (!testOpsArguments.isEmpty()) {
            ArrayList consoleOptions = new ArrayList();
            testOpsArguments.forEach(arg -> {
                StringConsoleOption TESTOPS_OPTION = new StringConsoleOption((String)arg){
                    private final /* synthetic */ String val$arg;
                    {
                        this.val$arg = string;
                    }

                    public String getOption() {
                        return this.val$arg;
                    }
                };
                consoleOptions.add((ConsoleOption<?>)TESTOPS_OPTION);
            });
            return consoleOptions;
        }
        return null;
    }

    private static boolean ensureLegalOption(String option) {
        if (option.startsWith("-")) {
            LogUtil.logError((String)MessageFormat.format(IntegrationAnalyticsMessages.MSG_ILLEGAL_OPTION_CHAR, option, "-"));
            return false;
        }
        int i = 0;
        while (i < option.length()) {
            char current = option.charAt(i);
            if (!Character.isLetterOrDigit(current) && !AnalyticsCommandFactory.isAllowedPunctuation(current)) {
                LogUtil.logError((String)MessageFormat.format(IntegrationAnalyticsMessages.MSG_ILLEGAL_OPTION_CHAR, option, Character.valueOf(current)));
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isAllowedPunctuation(char option) {
        String allowedPunctuation = "?._-";
        return allowedPunctuation.indexOf(option) != -1;
    }

    public static void registerTestopsCommand(List<String> arguments) throws Exception {
        List<String> testOpsCommand = AnalyticsCommandFactory.getTestopsCommandList(arguments);
        List<ConsoleOption<?>> newConsoleOptions = AnalyticsCommandFactory.createTestopsConsoleOptionList(testOpsCommand);
        if (newConsoleOptions != null) {
            ReportIntegrationContribution reportIntegrationContribution = ReportIntegrationFactory.getInstance().getAnalyticsProvider();
            List consoleOptions = reportIntegrationContribution.getConsoleOptionList();
            consoleOptions.addAll(newConsoleOptions);
            if (reportIntegrationContribution instanceof AnalyticsReportIntegration) {
                AnalyticsReportIntegration analyticsReportIntegration = (AnalyticsReportIntegration)reportIntegrationContribution;
                analyticsReportIntegration.setConsoleOptionList(consoleOptions);
            }
        }
    }
}

