/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.analytics.util;

import com.kms.katalon.controller.ProjectController;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class FileUtils {
    public static Path createPath(String path) {
        FileSystem fileSystem = FileSystems.getDefault();
        return fileSystem.getPath(path, new String[0]);
    }

    public static List<Path> scanFiles(String path, final String extension) {
        final LinkedList<Path> filePaths = new LinkedList<Path>();
        Path rootPath = FileUtils.createPath(path);
        try {
            Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path visitedFile, BasicFileAttributes attrs) throws IOException {
                    String fileName = visitedFile.toFile().getName();
                    boolean matched = Pattern.matches(extension, fileName);
                    if (matched) {
                        filePaths.add(visitedFile);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {}
        return filePaths;
    }

    public static List<Path> scanFiles(String path, String[] extensions) {
        File targetDir = new File(path);
        if (!targetDir.exists() || !targetDir.isDirectory()) {
            return Collections.emptyList();
        }
        File[] childrenFiles = targetDir.listFiles((dir, name) -> Arrays.asList(extensions).contains(com.google.common.io.Files.getFileExtension((String)name)));
        if (childrenFiles == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(childrenFiles).sorted(Comparator.comparing(File::getName)).map(File::toPath).collect(Collectors.toList());
    }

    public static String readFileToString(Path filePath) {
        try {
            return new String(Files.readAllBytes(filePath));
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static List<String> readLines(Path file) {
        List<String> lines = new ArrayList<String>();
        try {
            lines = Files.readAllLines(file, Charset.forName("UTF-8"));
        }
        catch (IOException iOException) {}
        return lines;
    }

    public static StringBuilder readFileContent(Path file) {
        StringBuilder xmlContentBuilder = new StringBuilder();
        List<String> lines = FileUtils.readLines(file);
        lines.stream().forEach(l -> xmlContentBuilder.append((String)l));
        return xmlContentBuilder;
    }

    public static Path createTemporaryFile(String prefix, String suffix) throws IOException {
        return FileUtils.createTemporaryFile(ProjectController.getInstance().getTempDir(), prefix, suffix);
    }

    public static Path createTemporaryFile(String tempFolderPath, String prefix, String suffix) throws IOException {
        Path tempFolder = Paths.get(tempFolderPath, new String[0]);
        if (Files.notExists(tempFolder, new LinkOption[0])) {
            Files.createDirectories(tempFolder, new FileAttribute[0]);
        }
        Path file = Files.createTempFile(tempFolder, prefix, suffix, new FileAttribute[0]);
        Files.deleteIfExists(file);
        return file;
    }
}

