/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.AssertException;
import graphql.Internal;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.regex.Pattern;

@Internal
public class Assert {
    private static final String invalidNameErrorMessage = "Name must be non-null, non-empty and match [_A-Za-z][_0-9A-Za-z]* - was '%s'";
    private static final Pattern validNamePattern = Pattern.compile("[_A-Za-z][_0-9A-Za-z]*");

    public static <T> T assertNotNullWithNPE(T object, Supplier<String> msg) {
        if (object != null) {
            return object;
        }
        throw new NullPointerException(msg.get());
    }

    public static <T> T assertNotNull(T object) {
        if (object != null) {
            return object;
        }
        return Assert.throwAssert("Object required to be not null", new Object[0]);
    }

    public static <T> T assertNotNull(T object, Supplier<String> msg) {
        if (object != null) {
            return object;
        }
        return Assert.throwAssert(msg.get(), new Object[0]);
    }

    public static <T> T assertNotNull(T object, String constantMsg) {
        if (object != null) {
            return object;
        }
        return Assert.throwAssert(constantMsg, new Object[0]);
    }

    public static <T> T assertNotNull(T object, String msgFmt, Object arg1) {
        if (object != null) {
            return object;
        }
        return Assert.throwAssert(msgFmt, arg1);
    }

    public static <T> T assertNotNull(T object, String msgFmt, Object arg1, Object arg2) {
        if (object != null) {
            return object;
        }
        return Assert.throwAssert(msgFmt, arg1, arg2);
    }

    public static <T> T assertNotNull(T object, String msgFmt, Object arg1, Object arg2, Object arg3) {
        if (object != null) {
            return object;
        }
        return Assert.throwAssert(msgFmt, arg1, arg2, arg3);
    }

    public static <T> void assertNull(T object, Supplier<String> msg) {
        if (object == null) {
            return;
        }
        Assert.throwAssert(msg.get(), new Object[0]);
    }

    public static <T> void assertNull(T object) {
        if (object == null) {
            return;
        }
        Assert.throwAssert("Object required to be null", new Object[0]);
    }

    public static <T> T assertNeverCalled() {
        return Assert.throwAssert("Should never been called", new Object[0]);
    }

    public static <T> T assertShouldNeverHappen(String format, Object ... args) {
        return Assert.throwAssert("Internal error: should never happen: %s", String.format(format, args));
    }

    public static <T> T assertShouldNeverHappen() {
        return Assert.throwAssert("Internal error: should never happen", new Object[0]);
    }

    public static <T> Collection<T> assertNotEmpty(Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            Assert.throwAssert("collection must be not null and not empty", new Object[0]);
        }
        return collection;
    }

    public static <T> Collection<T> assertNotEmpty(Collection<T> collection, Supplier<String> msg) {
        if (collection == null || collection.isEmpty()) {
            Assert.throwAssert(msg.get(), new Object[0]);
        }
        return collection;
    }

    public static void assertTrue(boolean condition, Supplier<String> msg) {
        if (condition) {
            return;
        }
        Assert.throwAssert(msg.get(), new Object[0]);
    }

    public static void assertTrue(boolean condition) {
        if (condition) {
            return;
        }
        Assert.throwAssert("condition expected to be true", new Object[0]);
    }

    public static void assertTrue(boolean condition, String constantMsg) {
        if (condition) {
            return;
        }
        Assert.throwAssert(constantMsg, new Object[0]);
    }

    public static void assertTrue(boolean condition, String msgFmt, Object arg1) {
        if (condition) {
            return;
        }
        Assert.throwAssert(msgFmt, arg1);
    }

    public static void assertTrue(boolean condition, String msgFmt, Object arg1, Object arg2) {
        if (condition) {
            return;
        }
        Assert.throwAssert(msgFmt, arg1, arg2);
    }

    public static void assertTrue(boolean condition, String msgFmt, Object arg1, Object arg2, Object arg3) {
        if (condition) {
            return;
        }
        Assert.throwAssert(msgFmt, arg1, arg2, arg3);
    }

    public static void assertFalse(boolean condition, Supplier<String> msg) {
        if (!condition) {
            return;
        }
        Assert.throwAssert(msg.get(), new Object[0]);
    }

    public static void assertFalse(boolean condition) {
        if (!condition) {
            return;
        }
        Assert.throwAssert("condition expected to be false", new Object[0]);
    }

    public static void assertFalse(boolean condition, String constantMsg) {
        if (!condition) {
            return;
        }
        Assert.throwAssert(constantMsg, new Object[0]);
    }

    public static void assertFalse(boolean condition, String msgFmt, Object arg1) {
        if (!condition) {
            return;
        }
        Assert.throwAssert(msgFmt, arg1);
    }

    public static void assertFalse(boolean condition, String msgFmt, Object arg1, Object arg2) {
        if (!condition) {
            return;
        }
        Assert.throwAssert(msgFmt, arg1, arg2);
    }

    public static void assertFalse(boolean condition, String msgFmt, Object arg1, Object arg2, Object arg3) {
        if (!condition) {
            return;
        }
        Assert.throwAssert(msgFmt, arg1, arg2, arg3);
    }

    public static String assertValidName(String name) {
        if (name != null && !name.isEmpty() && validNamePattern.matcher(name).matches()) {
            return name;
        }
        return (String)Assert.throwAssert(invalidNameErrorMessage, name);
    }

    private static <T> T throwAssert(String format, Object ... args) {
        throw new AssertException(String.format(format, args));
    }
}

