/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.GraphQLContext;
import graphql.Internal;
import graphql.PublicApi;
import graphql.collect.ImmutableMapWithNullValues;
import graphql.execution.MergedField;
import graphql.execution.TypeResolutionParameters;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.util.Map;
import java.util.function.Supplier;

@PublicApi
public class TypeResolutionEnvironment {
    private final Object object;
    private final Supplier<ImmutableMapWithNullValues<String, Object>> arguments;
    private final MergedField field;
    private final GraphQLType fieldType;
    private final GraphQLSchema schema;
    private final Object context;
    private final GraphQLContext graphQLContext;
    private final Object localContext;
    private final DataFetchingFieldSelectionSet fieldSelectionSet;

    @Internal
    public TypeResolutionEnvironment(TypeResolutionParameters parameters) {
        this.object = parameters.getValue();
        this.arguments = () -> ImmutableMapWithNullValues.copyOf(parameters.getArgumentValues());
        this.field = parameters.getField();
        this.fieldType = parameters.getFieldType();
        this.schema = parameters.getSchema();
        this.context = parameters.getContext();
        this.graphQLContext = parameters.getGraphQLContext();
        this.localContext = parameters.getLocalContext();
        this.fieldSelectionSet = parameters.getSelectionSet();
    }

    public <T> T getObject() {
        return (T)this.object;
    }

    public Map<String, Object> getArguments() {
        return this.arguments.get();
    }

    public MergedField getField() {
        return this.field;
    }

    public GraphQLType getFieldType() {
        return this.fieldType;
    }

    public GraphQLSchema getSchema() {
        return this.schema;
    }

    @Deprecated(since="2021-12-27")
    public <T> T getContext() {
        return (T)this.context;
    }

    public GraphQLContext getGraphQLContext() {
        return this.graphQLContext;
    }

    public <T> T getLocalContext() {
        return (T)this.localContext;
    }

    public DataFetchingFieldSelectionSet getSelectionSet() {
        return this.fieldSelectionSet;
    }
}

