/*
 * Decompiled with CFR 0.152.
 */
package graphql.parser;

import graphql.Internal;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

@Internal
public class SafeTokenReader
extends Reader {
    private final Reader delegate;
    private final int maxCharacters;
    private final Consumer<Integer> whenMaxCharactersExceeded;
    private int count;

    public SafeTokenReader(Reader delegate, int maxCharacters, Consumer<Integer> whenMaxCharactersExceeded) {
        this.delegate = delegate;
        this.maxCharacters = maxCharacters;
        this.whenMaxCharactersExceeded = whenMaxCharactersExceeded;
        this.count = 0;
    }

    private int checkHowMany(int read, int howMany) {
        if (read != -1) {
            this.count += howMany;
            if (this.count > this.maxCharacters) {
                this.whenMaxCharactersExceeded.accept(this.maxCharacters);
            }
        }
        return read;
    }

    @Override
    public int read(char @NotNull [] buff, int off, int len) throws IOException {
        int howMany = this.delegate.read(buff, off, len);
        return this.checkHowMany(howMany, howMany);
    }

    @Override
    public int read() throws IOException {
        int ch = this.delegate.read();
        return this.checkHowMany(ch, 1);
    }

    @Override
    public int read(@NotNull CharBuffer target) throws IOException {
        int howMany = this.delegate.read(target);
        return this.checkHowMany(howMany, howMany);
    }

    @Override
    public int read(char @NotNull [] buff) throws IOException {
        int howMany = this.delegate.read(buff);
        return this.checkHowMany(howMany, howMany);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate.skip(n);
    }

    @Override
    public boolean ready() throws IOException {
        return this.delegate.ready();
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.delegate.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
    }
}

