/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ContentFilterResultDetailsForPrompt;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ContentFilterResultsForPrompt
implements JsonSerializable<ContentFilterResultsForPrompt> {
    private final int promptIndex;
    private final ContentFilterResultDetailsForPrompt contentFilterResults;

    public int getPromptIndex() {
        return this.promptIndex;
    }

    public ContentFilterResultDetailsForPrompt getContentFilterResults() {
        return this.contentFilterResults;
    }

    private ContentFilterResultsForPrompt(int promptIndex, ContentFilterResultDetailsForPrompt contentFilterResults) {
        this.promptIndex = promptIndex;
        this.contentFilterResults = contentFilterResults;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("prompt_index", this.promptIndex);
        jsonWriter.writeJsonField("content_filter_results", (JsonSerializable)this.contentFilterResults);
        return jsonWriter.writeEndObject();
    }

    public static ContentFilterResultsForPrompt fromJson(JsonReader jsonReader) throws IOException {
        return (ContentFilterResultsForPrompt)jsonReader.readObject(reader -> {
            int promptIndex = 0;
            ContentFilterResultDetailsForPrompt contentFilterResults = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("prompt_index".equals(fieldName)) {
                    promptIndex = reader.getInt();
                    continue;
                }
                if ("content_filter_results".equals(fieldName)) {
                    contentFilterResults = ContentFilterResultDetailsForPrompt.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return new ContentFilterResultsForPrompt(promptIndex, contentFilterResults);
        });
    }
}

