/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws;

import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.reficio.ws.SoapMultiValuesProvider;

public class SoapContext {
    public static final SoapContext DEFAULT = SoapContext.builder().build();
    public static final SoapContext NO_CONTENT = SoapContext.builder().exampleContent(false).build();
    private final boolean typeComments;
    private final boolean valueComments;
    private final boolean exampleContent;
    private final boolean buildOptional;
    private final boolean alwaysBuildHeaders;
    private final Set<QName> excludedTypes;
    private final SoapMultiValuesProvider multiValuesProvider;

    public SoapContext(boolean exampleContent, boolean typeComments, boolean valueComments, boolean buildOptional, boolean alwaysBuildHeaders, Set<QName> excludedTypes, SoapMultiValuesProvider multiValuesProvider) {
        this.exampleContent = exampleContent;
        this.typeComments = typeComments;
        this.valueComments = valueComments;
        this.buildOptional = buildOptional;
        this.alwaysBuildHeaders = alwaysBuildHeaders;
        this.excludedTypes = new HashSet<QName>(excludedTypes);
        this.multiValuesProvider = multiValuesProvider;
    }

    public SoapContext(boolean exampleContent, boolean typeComments, boolean valueComments, boolean buildOptional, boolean alwaysBuildHeaders) {
        this.exampleContent = exampleContent;
        this.typeComments = typeComments;
        this.valueComments = valueComments;
        this.buildOptional = buildOptional;
        this.alwaysBuildHeaders = alwaysBuildHeaders;
        this.excludedTypes = new HashSet<QName>();
        this.multiValuesProvider = null;
    }

    public boolean isBuildOptional() {
        return this.buildOptional;
    }

    public boolean isAlwaysBuildHeaders() {
        return this.alwaysBuildHeaders;
    }

    public boolean isExampleContent() {
        return this.exampleContent;
    }

    public boolean isTypeComments() {
        return this.typeComments;
    }

    public boolean isValueComments() {
        return this.valueComments;
    }

    public Set<QName> getExcludedTypes() {
        return new HashSet<QName>(this.excludedTypes);
    }

    public SoapMultiValuesProvider getMultiValuesProvider() {
        return this.multiValuesProvider;
    }

    public static ContextBuilder builder() {
        return new ContextBuilder();
    }

    public static class ContextBuilder {
        private boolean exampleContent = true;
        private boolean typeComments = false;
        private boolean valueComments = false;
        private boolean buildOptional = true;
        private boolean alwaysBuildHeaders = true;
        private Set<QName> excludedTypes = new HashSet<QName>();
        private SoapMultiValuesProvider multiValuesProvider = null;

        public ContextBuilder exampleContent(boolean value) {
            this.exampleContent = value;
            return this;
        }

        public ContextBuilder typeComments(boolean value) {
            this.typeComments = value;
            return this;
        }

        public ContextBuilder valueComments(boolean value) {
            this.valueComments = value;
            return this;
        }

        public ContextBuilder buildOptional(boolean value) {
            this.buildOptional = value;
            return this;
        }

        public ContextBuilder alwaysBuildHeaders(boolean value) {
            this.alwaysBuildHeaders = value;
            return this;
        }

        public ContextBuilder excludedTypes(Set<QName> excludedTypes) {
            this.excludedTypes = new HashSet<QName>(excludedTypes);
            return this;
        }

        public ContextBuilder multiValuesProvider(SoapMultiValuesProvider multiValuesProvider) {
            this.multiValuesProvider = multiValuesProvider;
            return this;
        }

        public SoapContext build() {
            return new SoapContext(this.exampleContent, this.typeComments, this.valueComments, this.buildOptional, this.alwaysBuildHeaders, this.excludedTypes, this.multiValuesProvider);
        }
    }
}

