/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.controls;

import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class SimpleComboBox
extends Composite {
    private Label label;
    private CCombo input;
    private int style;

    public SimpleComboBox(Composite parent, int style) {
        super(parent, 0);
        this.style = style;
        this.init(this);
    }

    private void init(Composite parent) {
        ComponentBuilder.fromGrid(parent).gridSpacing(ComponentUtil.applyZoom(2)).build();
        this.label = ComponentBuilder.label(parent).fillHorizontal().build();
        this.input = ComponentBuilder.customComboBox(parent, this.style).background(ColorUtil.getWhiteBackgroundColor()).fillHorizontal().build();
        parent.pack();
    }

    public void add(String option) {
        this.input.add(option);
    }

    public void add(String option, int index) {
        this.input.add(option, index);
    }

    public void select(int index) {
        this.input.select(index);
    }

    public String[] getItems() {
        return this.input.getItems();
    }

    public void setForeground(Color color) {
        if (this.input != null) {
            this.input.setForeground(color);
        }
    }

    public void setEnabled(boolean enabled) {
        this.input.setEnabled(enabled);
        this.label.setForeground(ColorUtil.themeColor("919299", "919299"));
        super.setEnabled(enabled);
    }

    public void setMessage(String message) {
        this.label.setText(message);
    }

    public String getText() {
        return this.input.getText();
    }

    public void setText(String text) {
        this.input.setText(text);
    }
}

