/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.operation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.ICompositeOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class AbstractCompositeOperation
extends AbstractOperation
implements ICompositeOperation {
    private List<IUndoableOperation> operations = new ArrayList<IUndoableOperation>();

    public AbstractCompositeOperation(String label) {
        super(label);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        for (IUndoableOperation operation : this.operations) {
            operation.execute(monitor, info);
        }
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        for (IUndoableOperation operation : this.operations) {
            operation.redo(monitor, info);
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ArrayList<IUndoableOperation> revertOperations = new ArrayList<IUndoableOperation>(this.operations);
        Collections.reverse(revertOperations);
        for (IUndoableOperation operation : revertOperations) {
            operation.undo(monitor, info);
        }
        return Status.OK_STATUS;
    }

    public void add(IUndoableOperation operation) {
        if (operation == null) {
            return;
        }
        this.operations.add(operation);
    }

    public void remove(IUndoableOperation operation) {
        if (operation == null) {
            return;
        }
        this.operations.remove(operation);
    }
}

