/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.util;

import com.kms.katalon.composer.components.controls.FileInput;
import com.kms.katalon.composer.components.controls.HelpComposite;
import com.kms.katalon.composer.components.controls.SimpleComboBox;
import com.kms.katalon.composer.components.controls.SimpleTextField;
import com.kms.katalon.composer.components.controls.TextField;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentDataUtil;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentRole;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.InputValidator;
import com.kms.katalon.composer.components.util.MessageComponentBuilder;
import com.kms.katalon.composer.components.util.StyleContext;
import com.kms.katalon.composer.components.util.StyleUtil;
import com.kms.katalon.composer.resources.image.ImageManager;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ComponentBuilder<T extends Widget> {
    private Integer marginTop;
    private Integer marginRight;
    private Integer marginBottom;
    private Integer marginLeft;
    private T control;

    private Control getControl() {
        return (Control)this.control;
    }

    public ComponentBuilder(T control) {
        this.control = control;
    }

    public static <T extends Widget> ComponentBuilder<T> from(T control) {
        return new ComponentBuilder<T>(control);
    }

    public static ComponentBuilder<Label> separator(Composite parent) {
        return new ComponentBuilder<Label>(ComponentUtil.createSeparator(parent));
    }

    public static ComponentBuilder<Label> separator(Composite parent, int style) {
        return new ComponentBuilder<Label>(ComponentUtil.createSeparator(parent, style));
    }

    public static ComponentBuilder<Canvas> separator2(Composite parent) {
        return ComponentBuilder.separator2(parent, 1);
    }

    public static ComponentBuilder<Canvas> separator2(Composite parent, int width) {
        return ComponentBuilder.canvas(parent).autoHeight(width).customRender().fillHorizontal().borderRadius(width).background(ColorUtil.themeColor("#DDDDDD", "#46474D"));
    }

    public static ComponentBuilder<Canvas> separator2(Composite parent, int width, String lightThemeColor, String darkThemeColor) {
        return ComponentBuilder.canvas(parent).autoHeight(width).customRender().fillHorizontal().borderRadius(width).background(ColorUtil.themeColor(lightThemeColor, darkThemeColor));
    }

    public static ComponentBuilder<Canvas> emptyCell(Composite parent) {
        return new ComponentBuilder<Canvas>(ComponentUtil.createEmptyCell(parent));
    }

    public static ComponentBuilder<? extends Widget> linkOrLabel(Composite parent, String text) {
        return ComponentUtil.containsLink(text) ? new ComponentBuilder<Link>(ComponentUtil.createLink(parent)) : new ComponentBuilder<Label>(ComponentUtil.createLabel(parent));
    }

    public static ComponentBuilder<Label> label(Composite parent) {
        return new ComponentBuilder<Label>(ComponentUtil.createLabel(parent));
    }

    public static ComponentBuilder<Label> label(Composite parent, int style) {
        return new ComponentBuilder<Label>(ComponentUtil.createLabel(parent, style));
    }

    public static ComponentBuilder<Link> link(Composite parent) {
        return new ComponentBuilder<Link>(ComponentUtil.createLink(parent));
    }

    public static ComponentBuilder<Link> link(Composite parent, int style) {
        return new ComponentBuilder<Link>(ComponentUtil.createLink(parent, style));
    }

    public static ComponentBuilder<Text> text(Composite parent) {
        return new ComponentBuilder<Text>(ComponentUtil.createText(parent));
    }

    public static ComponentBuilder<Text> text(Composite parent, int style) {
        return new ComponentBuilder<Text>(ComponentUtil.createText(parent, style));
    }

    public static ComponentBuilder<TextField> textField(Composite parent) {
        return new ComponentBuilder<TextField>(ComponentUtil.createTextField(parent));
    }

    public static ComponentBuilder<TextField> textField(Composite parent, int style) {
        return new ComponentBuilder<TextField>(ComponentUtil.createTextField(parent, style));
    }

    public static ComponentBuilder<SimpleTextField> simpleTextField(Composite parent) {
        return new ComponentBuilder<SimpleTextField>(ComponentUtil.createSimpleTextField(parent));
    }

    public static ComponentBuilder<SimpleTextField> simpleTextField(Composite parent, int style) {
        return new ComponentBuilder<SimpleTextField>(ComponentUtil.createSimpleTextField(parent, style));
    }

    public static ComponentBuilder<StyledText> styledText(Composite parent) {
        return new ComponentBuilder<StyledText>(ComponentUtil.createStyleText(parent));
    }

    public static ComponentBuilder<StyledText> styledText(Composite parent, int style) {
        return new ComponentBuilder<StyledText>(ComponentUtil.createStyleText(parent, style));
    }

    public static ComponentBuilder<Text> textArea(Composite parent) {
        return new ComponentBuilder<Text>(ComponentUtil.createTextArea(parent));
    }

    public static ComponentBuilder<Text> textArea(Composite parent, int style) {
        return new ComponentBuilder<Text>(ComponentUtil.createTextArea(parent, style));
    }

    public static ComponentBuilder<FileInput> fileInput(Composite parent) {
        return new ComponentBuilder<FileInput>(ComponentUtil.createFileInput(parent));
    }

    public static ComponentBuilder<FileInput> fileInput(Composite parent, int style) {
        return new ComponentBuilder<FileInput>(ComponentUtil.createFileInput(parent, style));
    }

    public static ComponentBuilder<Button> button(Composite parent) {
        return new ComponentBuilder<Button>(ComponentUtil.createButton(parent));
    }

    public static ComponentBuilder<Button> button(Composite parent, int style) {
        return new ComponentBuilder<Button>(ComponentUtil.createButton(parent, style));
    }

    public static ComponentBuilder<Canvas> iconButton(Composite parent) {
        return new ComponentBuilder<Canvas>(ComponentUtil.createIconButton(parent));
    }

    public static ComponentBuilder<Canvas> iconButton(Composite parent, String imageKey) {
        return new ComponentBuilder<Canvas>(ComponentUtil.createIconButton(parent, imageKey));
    }

    public static ComponentBuilder<Canvas> iconButton(Composite parent, String imageKey, int size) {
        return new ComponentBuilder<Canvas>(ComponentUtil.createIconButton(parent, imageKey, size));
    }

    public static ComponentBuilder<Canvas> iconButton(Composite parent, String imageKey, int width, int height) {
        return new ComponentBuilder<Canvas>(ComponentUtil.createIconButton(parent, imageKey, width, height));
    }

    public static ComponentBuilder<Canvas> iconButton(Composite parent, Image image) {
        return new ComponentBuilder<Canvas>(ComponentUtil.createIconButton(parent, image));
    }

    public static ComponentBuilder<Canvas> iconButton(Composite parent, Image image, int size) {
        return new ComponentBuilder<Canvas>(ComponentUtil.createIconButton(parent, image));
    }

    public static ComponentBuilder<Canvas> iconButton(Composite parent, Image image, int width, int height) {
        return new ComponentBuilder<Canvas>(ComponentUtil.createIconButton(parent, image));
    }

    public static ComponentBuilder<Canvas> menuItem(Composite parent) {
        return new ComponentBuilder<Canvas>(ComponentUtil.createMenuItem(parent));
    }

    public static ComponentBuilder<HelpComposite> helpButton(Composite parent, String docUrl) {
        return new ComponentBuilder<HelpComposite>(ComponentUtil.createHelpButton(parent, docUrl));
    }

    public static ComponentBuilder<HelpComposite> helpButton(Composite parent, String docUrl, int style) {
        return new ComponentBuilder<HelpComposite>(ComponentUtil.createHelpButton(parent, docUrl, style));
    }

    public static ComponentBuilder<Button> checkBox(Composite parent, int style) {
        return new ComponentBuilder<Button>(ComponentUtil.createButton(parent, style | 0x20));
    }

    public static ComponentBuilder<Button> checkBox(Composite parent) {
        return new ComponentBuilder<Button>(ComponentUtil.createButton(parent, 32));
    }

    public static ComponentBuilder<Button> radio(Composite parent) {
        return new ComponentBuilder<Button>(ComponentUtil.createButton(parent, 16));
    }

    public static ComponentBuilder<Button> radio(Composite parent, int style) {
        return new ComponentBuilder<Button>(ComponentUtil.createButton(parent, style | 0x10));
    }

    public static ComponentBuilder<Combo> comboBox(Composite parent) {
        return new ComponentBuilder<Combo>(ComponentUtil.createComboBox(parent));
    }

    public static ComponentBuilder<Combo> comboBox(Composite parent, int style) {
        return new ComponentBuilder<Combo>(ComponentUtil.createComboBox(parent, style));
    }

    public static ComponentBuilder<CCombo> customComboBox(Composite parent, int style) {
        return new ComponentBuilder<CCombo>(ComponentUtil.createCustomComboBox(parent, style));
    }

    public static ComponentBuilder<CCombo> customComboBox(Composite parent) {
        return new ComponentBuilder<CCombo>(ComponentUtil.createCustomComboBox(parent));
    }

    public static ComponentBuilder<SimpleComboBox> simpleComboBox(Composite parent, int style) {
        return new ComponentBuilder<SimpleComboBox>(ComponentUtil.createSimpleComboBox(parent, style));
    }

    public static ComponentBuilder<SimpleComboBox> simpleComboBox(Composite parent) {
        return new ComponentBuilder<SimpleComboBox>(ComponentUtil.createSimpleComboBox(parent));
    }

    public static ComponentBuilder<Canvas> image(Composite parent, String imageKey) {
        Canvas canvas = ComponentUtil.createCanvasImage(parent, imageKey);
        return new ComponentBuilder<Canvas>(canvas);
    }

    public static ComponentBuilder<Canvas> image(Composite parent, String imageKey, int maxHeight) {
        Canvas canvas = ComponentUtil.createCanvasImage(parent, imageKey, maxHeight);
        return new ComponentBuilder<Canvas>(canvas);
    }

    public static ComponentBuilder<Canvas> image(Composite parent, String imageKey, int width, int height) {
        Canvas canvas = ComponentUtil.createCanvasImage(parent, imageKey, width, height);
        return new ComponentBuilder<Canvas>(canvas);
    }

    public static ComponentBuilder<Canvas> canvas(Composite parent) {
        return new ComponentBuilder<Canvas>(ComponentUtil.createCanvas(parent));
    }

    public static ComponentBuilder<Canvas> canvas(Composite parent, ImageLoader loader) {
        return new ComponentBuilder<Canvas>(ComponentUtil.createAnimatedCanvas(parent, loader));
    }

    public static ComponentBuilder<Canvas> canvas(Composite parent, Image image) {
        return new ComponentBuilder<Canvas>(ComponentUtil.createCanvas(parent, image));
    }

    public static ComponentBuilder<Canvas> canvas(Composite parent, Image image, int width, int height) {
        return new ComponentBuilder<Canvas>(ComponentUtil.createCanvas(parent, image, width, height));
    }

    public static ComponentBuilder<Browser> browser(Composite parent) {
        return new ComponentBuilder<Browser>(ComponentUtil.createBrowser(parent));
    }

    public static ComponentBuilder<Browser> browser(Composite parent, int style) {
        return new ComponentBuilder<Browser>(ComponentUtil.createBrowser(parent, style));
    }

    public static ComponentBuilder<ToolBar> toolBar(Composite parent) {
        return new ComponentBuilder<ToolBar>(ComponentUtil.createToolBar(parent));
    }

    public static ComponentBuilder<ToolBar> toolBar(Composite parent, int style) {
        return new ComponentBuilder<ToolBar>(ComponentUtil.createToolBar(parent, style));
    }

    public static ComponentBuilder<ToolItem> toolItem(Composite parent) {
        return new ComponentBuilder<ToolItem>(ComponentUtil.createToolItem(parent));
    }

    public static ComponentBuilder<ToolItem> toolItem(Composite parent, int style) {
        return new ComponentBuilder<ToolItem>(ComponentUtil.createToolItem(parent, style));
    }

    public static MessageComponentBuilder message() {
        return MessageComponentBuilder.create();
    }

    public ComponentBuilder<T> onBrowserLoaded(ComponentUtil.BrowserLoadedListener listener) {
        Control control = this.getControl();
        if (control instanceof Browser) {
            Browser browser = (Browser)control;
            ComponentUtil.onBrowserLoaded(browser, listener);
        }
        return this;
    }

    public ComponentBuilder<T> defaultBrowserConfig() {
        Control control = this.getControl();
        if (control instanceof Browser) {
            Browser browser = (Browser)control;
            ComponentUtil.preventDefaultInternalUrls(browser);
        }
        return this;
    }

    public ComponentBuilder<T> preventURLs(String ... urlRegExps) {
        Control control = this.getControl();
        if (control instanceof Browser) {
            Browser browser = (Browser)control;
            ComponentUtil.preventUrls(browser, urlRegExps);
        }
        return this;
    }

    public ComponentBuilder<T> interceptURLs(String urlRegExp, ComponentUtil.LocationChangingListener listener) {
        Control control = this.getControl();
        if (control instanceof Browser) {
            Browser browser = (Browser)control;
            ComponentUtil.interceptURLs(browser, listener, urlRegExp);
        }
        return this;
    }

    public ComponentBuilder<T> browserFunction(String functionName, ComponentUtil.BrowserFunctionHandler function) {
        Control control = this.getControl();
        if (control instanceof Browser) {
            Browser browser = (Browser)control;
            ComponentUtil.defineBrowserFunction(browser, functionName, function);
        }
        return this;
    }

    public ComponentBuilder<T> url(String url) {
        Control control = this.getControl();
        if (control instanceof Browser) {
            Browser browser = (Browser)control;
            UISynchronizeService.asyncExec(() -> {
                if (Objects.nonNull(browser) && !browser.isDisposed()) {
                    browser.setUrl(url);
                }
            });
        }
        return this;
    }

    public static ComponentBuilder<CTabFolder> tabFolder(Composite parent) {
        return new ComponentBuilder<CTabFolder>(ComponentUtil.createTabFolder(parent));
    }

    public static ComponentBuilder<ToolBar> toolbar(Composite parent, int style) {
        return new ComponentBuilder<ToolBar>(ComponentUtil.createToolbar(parent, style));
    }

    public static ComponentBuilder<SashForm> sashForm(Composite parent) {
        return new ComponentBuilder<SashForm>(ComponentUtil.createSashForm(parent));
    }

    public static ComponentBuilder<SashForm> sashForm(Composite parent, int style) {
        return new ComponentBuilder<SashForm>(ComponentUtil.createSashForm(parent, style));
    }

    public static ComponentBuilder<Composite> gridContainer(Composite parent) {
        return new ComponentBuilder<Composite>(ComponentUtil.createGridContainer(parent));
    }

    public static ComponentBuilder<Composite> gridContainer(Composite parent, int numCols) {
        return new ComponentBuilder<Composite>(ComponentUtil.createGridContainer(parent, numCols));
    }

    public static ComponentBuilder<Composite> gridContainer(Composite parent, int numCols, int style) {
        return new ComponentBuilder<Composite>(ComponentUtil.createGridContainer(parent, numCols, style));
    }

    public static ComponentBuilder<Composite> gridContainer(Composite parent, int numCols, boolean equalsWidth) {
        return new ComponentBuilder<Composite>(ComponentUtil.createGridContainer(parent, numCols, equalsWidth));
    }

    public static ComponentBuilder<Composite> gridContainer(Composite parent, int numCols, boolean equalsWidth, int style) {
        return new ComponentBuilder<Composite>(ComponentUtil.createGridContainer(parent, numCols, equalsWidth, style));
    }

    public static ComponentBuilder<Composite> fromGrid(Composite container) {
        return ComponentBuilder.fromGrid(container, 1);
    }

    public static ComponentBuilder<Composite> fromGrid(Composite container, int numCols) {
        return ComponentBuilder.fromGrid(container, numCols, false);
    }

    public static ComponentBuilder<Composite> fromGrid(Composite container, int numCols, boolean equalWidth) {
        ComponentUtil.appendGridLayout(container, numCols, equalWidth);
        StyleContext.style((Control)container);
        return new ComponentBuilder<Composite>(container);
    }

    public static ComponentBuilder<Composite> colContainer(Composite parent) {
        return new ComponentBuilder<Composite>(ComponentUtil.createRowContainer(parent, 0, 512));
    }

    public static ComponentBuilder<Composite> colContainer(Composite parent, int style) {
        return new ComponentBuilder<Composite>(ComponentUtil.createRowContainer(parent, style, 512));
    }

    public static ComponentBuilder<Composite> rowContainer(Composite parent) {
        return new ComponentBuilder<Composite>(ComponentUtil.createRowContainer(parent));
    }

    public static ComponentBuilder<Composite> rowContainer(Composite parent, int style) {
        return new ComponentBuilder<Composite>(ComponentUtil.createRowContainer(parent, style));
    }

    public static ComponentBuilder<Composite> rowContainer(Composite parent, int style, int type) {
        return new ComponentBuilder<Composite>(ComponentUtil.createRowContainer(parent, style, type));
    }

    public static ComponentBuilder<Composite> stackContainer(Composite parent) {
        return new ComponentBuilder<Composite>(ComponentUtil.createStackContainer(parent));
    }

    public static ComponentBuilder<Composite> stackContainer(Composite parent, int style) {
        return new ComponentBuilder<Composite>(ComponentUtil.createStackContainer(parent, style));
    }

    public static ComponentBuilder<SashForm> splitVerticalContainer(Composite parent) {
        return new ComponentBuilder<SashForm>(ComponentUtil.createSplitVerticalContainer(parent));
    }

    public static ComponentBuilder<SashForm> splitVerticalContainer(Composite parent, int style) {
        return new ComponentBuilder<SashForm>(ComponentUtil.createSplitVerticalContainer(parent, style));
    }

    public static ComponentBuilder<SashForm> splitHorizontalContainer(Composite parent) {
        return new ComponentBuilder<SashForm>(ComponentUtil.createSplitHorizontalContainer(parent));
    }

    public static ComponentBuilder<SashForm> splitHorizontalContainer(Composite parent, int style) {
        return new ComponentBuilder<SashForm>(ComponentUtil.createSplitHorizontalContainer(parent, style));
    }

    public static ComponentBuilder<SashForm> splitContainer(Composite parent) {
        return new ComponentBuilder<SashForm>(ComponentUtil.createSplitContainer(parent));
    }

    public static ComponentBuilder<SashForm> splitContainer(Composite parent, int style) {
        return new ComponentBuilder<SashForm>(ComponentUtil.createSplitContainer(parent, style));
    }

    public static ComponentBuilder<Composite> fillContainer(Composite parent) {
        return new ComponentBuilder<Composite>(ComponentUtil.createFillContainer(parent));
    }

    public static ComponentBuilder<Composite> fillContainer(Composite parent, int style) {
        return new ComponentBuilder<Composite>(ComponentUtil.createFillContainer(parent, style));
    }

    public static ComponentBuilder<Composite> fillContainer(Composite parent, int style, int type) {
        return new ComponentBuilder<Composite>(ComponentUtil.createFillContainer(parent, style, type));
    }

    public static ComponentBuilder<Composite> menuContainer(Composite parent) {
        return new ComponentBuilder<Composite>(ComponentUtil.createMenuContainer(parent));
    }

    public static ComponentBuilder<Composite> menuContainer(Composite parent, int numCols) {
        return new ComponentBuilder<Composite>(ComponentUtil.createMenuContainer(parent, numCols));
    }

    public static ComponentBuilder<Composite> menuContainer(Composite parent, int numCols, int style) {
        return new ComponentBuilder<Composite>(ComponentUtil.createMenuContainer(parent, numCols, style));
    }

    public static ComponentBuilder<Group> group(Composite parent) {
        return new ComponentBuilder<Group>(ComponentUtil.createGroup(parent));
    }

    public static ComponentBuilder<Group> group(Composite parent, int style) {
        return new ComponentBuilder<Group>(ComponentUtil.createGroup(parent, style));
    }

    public ComponentBuilder<T> gridLayout() {
        Control control = this.getControl();
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            ComponentUtil.setGridLayout((Control)composite);
        }
        return this;
    }

    public ComponentBuilder<T> gridLayout(int numCols) {
        Control control = this.getControl();
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            ComponentUtil.setGridLayout((Control)composite, numCols);
        }
        return this;
    }

    public ComponentBuilder<T> gridLayout(int numCols, boolean equalWidth) {
        Control control = this.getControl();
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            ComponentUtil.setGridLayout((Control)composite, numCols, equalWidth);
        }
        return this;
    }

    public ComponentBuilder<T> fillLayout() {
        T t = this.control;
        if (t instanceof Composite) {
            Composite composite = (Composite)t;
            ComponentUtil.setFillLayout((Control)composite);
        }
        return this;
    }

    public ComponentBuilder<T> marginTop(int marginTop) {
        this.marginTop = marginTop;
        return this;
    }

    public ComponentBuilder<T> marginRight(int marginRight) {
        this.marginRight = marginRight;
        return this;
    }

    public ComponentBuilder<T> marginBottom(int marginBottom) {
        this.marginBottom = marginBottom;
        return this;
    }

    public ComponentBuilder<T> marginLeft(int marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    public ComponentBuilder<T> groupIndent() {
        ComponentUtil.setGroupIndent(this.getControl());
        return this;
    }

    public ComponentBuilder<T> groupIndent(int level) {
        ComponentUtil.setGroupIndent(this.getControl(), level);
        return this;
    }

    public ComponentBuilder<T> horizontalIndent(int horizontalIndent) {
        ComponentUtil.setHorizontalIndent(this.getControl(), horizontalIndent);
        return this;
    }

    public ComponentBuilder<T> verticalIndent(int verticalIndent) {
        ComponentUtil.setVerticalIndent(this.getControl(), verticalIndent);
        return this;
    }

    public ComponentBuilder<T> marginHorizontal(int marginWidth) {
        this.marginRight = marginWidth;
        this.marginLeft = marginWidth;
        return this;
    }

    public ComponentBuilder<T> marginVertical(int marginHeight) {
        this.marginTop = marginHeight;
        this.marginBottom = marginHeight;
        return this;
    }

    public ComponentBuilder<T> margin(int margin) {
        this.margin(margin, margin);
        return this;
    }

    public ComponentBuilder<T> margin(int marginHeight, int marginWidth) {
        this.margin(marginHeight, marginWidth, marginHeight);
        return this;
    }

    public ComponentBuilder<T> margin(int marginTop, int marginWidth, int marginBottom) {
        this.margin(marginTop, marginWidth, marginBottom, marginWidth);
        return this;
    }

    public ComponentBuilder<T> margin(int marginTop, int marginRight, int marginBottom, int marginLeft) {
        this.marginTop = marginTop;
        this.marginRight = marginRight;
        this.marginBottom = marginBottom;
        this.marginLeft = marginLeft;
        return this;
    }

    public ComponentBuilder<T> gridVerticalSpacing(int verticalSpacing) {
        Control control = this.getControl();
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            ComponentUtil.setGridVerticalSpacing(composite, verticalSpacing);
        }
        return this;
    }

    public ComponentBuilder<T> gridHorizontalSpacing(int horizontalSpacing) {
        Control control = this.getControl();
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            ComponentUtil.setHorizontalSpacing(composite, horizontalSpacing);
        }
        return this;
    }

    public ComponentBuilder<T> gridSpacing(int spacing) {
        Control control = this.getControl();
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            ComponentUtil.setSpacing(composite, spacing);
        }
        return this;
    }

    public ComponentBuilder<T> gridSpacing(int verticalSpacing, int horizontalSpacing) {
        Control control = this.getControl();
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            ComponentUtil.setSpacing(composite, verticalSpacing, horizontalSpacing);
        }
        return this;
    }

    public ComponentBuilder<T> rowSpacing(int spacing) {
        Control control = this.getControl();
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            ComponentUtil.setRowSpacing(composite, spacing);
        }
        return this;
    }

    public ComponentBuilder<T> rowJustify() {
        return this.rowJustify(true);
    }

    public ComponentBuilder<T> rowJustify(boolean justify) {
        Composite composite;
        Control control = this.getControl();
        if (control instanceof Composite && (composite = (Composite)control).getLayout() instanceof RowLayout) {
            ComponentUtil.setRowJustify(composite, justify);
        }
        return this;
    }

    public ComponentBuilder<T> fillHorizontal() {
        ComponentUtil.gridFillHorizontal(this.getControl());
        return this;
    }

    public ComponentBuilder<T> noFillHorizontal() {
        ComponentUtil.gridFillHorizontal(this.getControl(), false);
        return this;
    }

    public ComponentBuilder<T> fillVertical() {
        ComponentUtil.gridFillVertical(this.getControl());
        return this;
    }

    public ComponentBuilder<T> noFillVertical() {
        ComponentUtil.gridFillVertical(this.getControl(), false);
        return this;
    }

    public ComponentBuilder<T> fill() {
        ComponentUtil.gridFill(this.getControl());
        return this;
    }

    public ComponentBuilder<T> noFill() {
        ComponentUtil.gridFill(this.getControl(), false);
        return this;
    }

    public ComponentBuilder<T> numCols(int numCols) {
        ComponentUtil.setNumCols(this.getControl(), numCols);
        return this;
    }

    public ComponentBuilder<T> center() {
        ComponentUtil.gridAlignCenter(this.getControl());
        return this;
    }

    public ComponentBuilder<T> left() {
        ComponentUtil.gridAlignLeft(this.getControl());
        return this;
    }

    public ComponentBuilder<T> right() {
        ComponentUtil.gridAlignRight(this.getControl());
        return this;
    }

    public ComponentBuilder<T> align(int align) {
        ComponentUtil.gridAlign(this.getControl(), align);
        return this;
    }

    public ComponentBuilder<T> top() {
        ComponentUtil.gridAlignTop(this.getControl());
        return this;
    }

    public ComponentBuilder<T> bottom() {
        ComponentUtil.gridAlignBottom(this.getControl());
        return this;
    }

    public ComponentBuilder<T> middle() {
        ComponentUtil.gridAlignMiddle(this.getControl());
        return this;
    }

    public ComponentBuilder<T> verticalAlign(int align) {
        ComponentUtil.gridVerticalAlign(this.getControl(), align);
        return this;
    }

    public ComponentBuilder<T> textCenter() {
        ComponentUtil.textCenter(this.getControl());
        return this;
    }

    public ComponentBuilder<T> textLeft() {
        ComponentUtil.textLeft(this.getControl());
        return this;
    }

    public ComponentBuilder<T> textRight() {
        ComponentUtil.textRight(this.getControl());
        return this;
    }

    public ComponentBuilder<T> textAlign(int align) {
        ComponentUtil.textAlign(this.getControl(), align);
        return this;
    }

    public ComponentBuilder<T> font(Font font) {
        this.getControl().setFont(font);
        return this;
    }

    public ComponentBuilder<T> fontSize(int fontSize) {
        ComponentUtil.fontSize(this.getControl(), fontSize);
        return this;
    }

    public ComponentBuilder<T> normal() {
        return this.fontStyle(0);
    }

    public ComponentBuilder<T> bold() {
        return this.fontStyle(1);
    }

    public ComponentBuilder<T> italic() {
        return this.fontStyle(2);
    }

    public ComponentBuilder<T> boldItalic() {
        return this.fontStyle(3);
    }

    public ComponentBuilder<T> fontStyle(int fontStyle) {
        ComponentUtil.fontStyle(this.getControl(), fontStyle);
        return this;
    }

    public ComponentBuilder<T> fontFamily(String fontFamily) {
        ComponentUtil.fontFamily(this.getControl(), fontFamily);
        return this;
    }

    public ComponentBuilder<T> colSpan(int colSpan) {
        ComponentUtil.setGridColSpan(this.getControl(), colSpan);
        return this;
    }

    public ComponentBuilder<T> rowSpan(int rowSpan) {
        ComponentUtil.setGridRowSpan(this.getControl(), rowSpan);
        return this;
    }

    public ComponentBuilder<T> width(int width) {
        ComponentUtil.setWidth(this.getControl(), width);
        return this;
    }

    public ComponentBuilder<T> sashWidth(int width) {
        T t = this.control;
        if (t instanceof SashForm) {
            SashForm sashForm = (SashForm)t;
            ComponentUtil.setSashWidth((Control)sashForm, width);
        }
        return this;
    }

    public ComponentBuilder<T> autoWidth(int width) {
        return this.width(ComponentUtil.applyZoom(width));
    }

    public ComponentBuilder<T> height(int height) {
        ComponentUtil.setHeight(this.getControl(), height);
        return this;
    }

    public ComponentBuilder<T> rows(int numRows) {
        ComponentUtil.setRows(this.getControl(), numRows);
        return this;
    }

    public ComponentBuilder<T> autoHeight(int height) {
        return this.height(ComponentUtil.applyZoom(height));
    }

    public ComponentBuilder<T> size(int width, int height) {
        ComponentUtil.setSize(this.getControl(), width, height);
        return this;
    }

    public ComponentBuilder<T> size(int size) {
        ComponentUtil.setSize(this.getControl(), size);
        return this;
    }

    public ComponentBuilder<T> autoSize(int width, int height) {
        ComponentUtil.autoSize(this.getControl(), width, height);
        return this;
    }

    public ComponentBuilder<T> autoSize(int size) {
        ComponentUtil.autoSize(this.getControl(), size);
        return this;
    }

    public ComponentBuilder<T> sizeXS() {
        ComponentUtil.sizeXS(this.getControl());
        return this;
    }

    public ComponentBuilder<T> sizeXS(int width) {
        ComponentUtil.sizeXS(this.getControl(), width);
        return this;
    }

    public ComponentBuilder<T> autoSizeXS(int width) {
        ComponentUtil.autoSizeXS(this.getControl(), width);
        return this;
    }

    public ComponentBuilder<T> sizeSM() {
        ComponentUtil.sizeSM(this.getControl());
        return this;
    }

    public ComponentBuilder<T> sizeSM(int width) {
        ComponentUtil.sizeSM(this.getControl(), width);
        return this;
    }

    public ComponentBuilder<T> autoSizeSM(int width) {
        ComponentUtil.autoSizeSM(this.getControl(), width);
        return this;
    }

    public ComponentBuilder<T> sizeMD() {
        ComponentUtil.sizeMD(this.getControl());
        return this;
    }

    public ComponentBuilder<T> sizeMD(int width) {
        ComponentUtil.sizeMD(this.getControl(), width);
        return this;
    }

    public ComponentBuilder<T> autoSizeMD(int width) {
        ComponentUtil.autoSizeMD(this.getControl(), width);
        return this;
    }

    public ComponentBuilder<T> sizeLG() {
        ComponentUtil.sizeLG(this.getControl());
        return this;
    }

    public ComponentBuilder<T> sizeLG(int width) {
        ComponentUtil.sizeLG(this.getControl(), width);
        return this;
    }

    public ComponentBuilder<T> autoSizeLG(int width) {
        ComponentUtil.autoSizeLG(this.getControl(), width);
        return this;
    }

    public ComponentBuilder<T> sizeXL() {
        ComponentUtil.sizeXL(this.getControl());
        return this;
    }

    public ComponentBuilder<T> sizeXL(int width) {
        ComponentUtil.sizeXL(this.getControl(), width);
        return this;
    }

    public ComponentBuilder<T> autoSizeXL(int width) {
        ComponentUtil.autoSizeXL(this.getControl(), width);
        return this;
    }

    public ComponentBuilder<T> imageSize(int width, int height) {
        ComponentUtil.setImageSize(this.getControl(), width, height);
        return this;
    }

    public ComponentBuilder<T> enableAutoWidth() {
        ComponentUtil.enableAutoWidth(this.getControl());
        return this;
    }

    public ComponentBuilder<T> disableAutoWidth() {
        ComponentUtil.disableAutoWidth(this.getControl());
        return this;
    }

    public ComponentBuilder<T> applyZoom() {
        ComponentUtil.applyZoom(this.getControl());
        return this;
    }

    public ComponentBuilder<T> minWidth(int minWidth) {
        ComponentUtil.setMinWidth(this.getControl(), minWidth);
        return this;
    }

    public ComponentBuilder<T> minHeight(int minHeight) {
        ComponentUtil.setMinHeight(this.getControl(), minHeight);
        return this;
    }

    public ComponentBuilder<T> minSize(int minWidth, int minHeight) {
        ComponentUtil.setMinSize(this.getControl(), minWidth, minHeight);
        return this;
    }

    public ComponentBuilder<T> minSize(int minSize) {
        ComponentUtil.setMinSize(this.getControl(), minSize);
        return this;
    }

    public ComponentBuilder<T> text(String text) {
        ComponentUtil.setText(this.control, text);
        return this;
    }

    public ComponentBuilder<T> linkButtonText(String text) {
        return this.text(ComponentUtil.wrapLinkButton(text));
    }

    public ComponentBuilder<T> contentAlign(int align) {
        ComponentUtil.setContentAlign(this.getControl(), align);
        return this;
    }

    public ComponentBuilder<T> title(String title) {
        ComponentUtil.setTitle(this.getControl(), title);
        return this;
    }

    public ComponentBuilder<T> limit(int maxLength) {
        ComponentUtil.setLimit(this.getControl(), maxLength);
        return this;
    }

    public <D> ComponentBuilder<T> options(Map<String, D> options) {
        ComponentUtil.setOptions(this.getControl(), options);
        return this;
    }

    public ComponentBuilder<T> options(String ... options) {
        ComponentUtil.setOptions(this.getControl(), options);
        return this;
    }

    public ComponentBuilder<T> select() {
        ComponentUtil.select((Widget)this.getControl());
        return this;
    }

    public ComponentBuilder<T> select(int index) {
        ComponentUtil.select((Widget)this.getControl(), index);
        return this;
    }

    public ComponentBuilder<T> linkTo(String url) {
        ComponentUtil.linkTo(this.control, url);
        return this;
    }

    public ComponentBuilder<T> linkTo(String label, String url) {
        ComponentUtil.linkTo(this.control, label, url);
        return this;
    }

    public ComponentBuilder<T> placeholder(String message) {
        ComponentUtil.setMessage((Widget)this.getControl(), message);
        return this;
    }

    public ComponentBuilder<T> maskPassword() {
        ComponentUtil.maskPassword((Widget)this.getControl());
        return this;
    }

    public ComponentBuilder<T> maskPassword(char maskCharacter) {
        ComponentUtil.setPasswordMaskCharacter((Widget)this.getControl(), maskCharacter);
        return this;
    }

    public ComponentBuilder<T> validateEmail(InputValidator validator) {
        validator.register(() -> ComponentDataUtil.getText(this.control), InputValidator.EMAIL);
        this.onChange(event -> validator.triggerValidation());
        return this;
    }

    public ComponentBuilder<T> validatePassword(InputValidator validator) {
        validator.register(() -> ComponentDataUtil.getText(this.control), InputValidator.PASSWORD);
        this.onChange(event -> validator.triggerValidation());
        return this;
    }

    public ComponentBuilder<T> focus() {
        this.getControl().setFocus();
        return this;
    }

    public ComponentBuilder<T> forceFocus() {
        this.getControl().forceFocus();
        return this;
    }

    public ComponentBuilder<T> check() {
        ComponentUtil.check((Widget)this.getControl());
        return this;
    }

    public ComponentBuilder<T> image(String imageKey) {
        ComponentUtil.setImage(this.control, ImageManager.getImage((String)imageKey));
        return this;
    }

    public ComponentBuilder<T> image(String imageKey, int align) {
        ComponentUtil.setImage(this.control, ImageManager.getImage((String)imageKey), align);
        return this;
    }

    public ComponentBuilder<T> image(Image image) {
        ComponentUtil.setImage(this.control, image);
        return this;
    }

    public ComponentBuilder<T> image(Image image, int align) {
        ComponentUtil.setImage(this.control, image, align);
        return this;
    }

    public ComponentBuilder<T> disabledImage(Image image) {
        ComponentUtil.setDisabledImage(this.control, image);
        return this;
    }

    public ComponentBuilder<T> disabledImage(Image image, int align) {
        ComponentUtil.setDisabledImage(this.control, image, align);
        return this;
    }

    public ComponentBuilder<T> debug() {
        return this.background(ColorUtil.getColor("#ff0000"));
    }

    public ComponentBuilder<T> color(Color color) {
        ComponentUtil.setColor(this.getControl(), color);
        return this;
    }

    public ComponentBuilder<T> foreground(Color color) {
        T t = this.control;
        if (t instanceof Control) {
            Control aControl = (Control)t;
            ComponentUtil.setForeground(aControl, color);
        }
        return this;
    }

    public ComponentBuilder<T> background(Color color) {
        ComponentUtil.setBackground(this.getControl(), color);
        return this;
    }

    public ComponentBuilder<T> backgroundImage(Image image) {
        ComponentUtil.setBackgroundImage(this.getControl(), image);
        return this;
    }

    public ComponentBuilder<T> backgroundMode(int mode) {
        ComponentUtil.setBackgroundMode(this.getControl(), mode);
        return this;
    }

    public ComponentBuilder<T> hoverColor(Color color) {
        ComponentUtil.setHoverColor(this.getControl(), color);
        return this;
    }

    public ComponentBuilder<T> hoverBackground(Color color) {
        ComponentUtil.setHoverBackground(this.getControl(), color);
        return this;
    }

    public ComponentBuilder<T> activeColor(Color color) {
        ComponentUtil.setActiveColor(this.getControl(), color);
        return this;
    }

    public ComponentBuilder<T> activeBackground(Color color) {
        ComponentUtil.setActiveBackground(this.getControl(), color);
        return this;
    }

    public ComponentBuilder<T> border() {
        ComponentUtil.setBorder(this.getControl());
        return this;
    }

    public ComponentBuilder<T> border(int width) {
        ComponentUtil.setBorder(this.getControl(), width);
        return this;
    }

    public ComponentBuilder<T> border(Color color) {
        ComponentUtil.setBorder(this.getControl(), color);
        return this;
    }

    public ComponentBuilder<T> border(int width, Color color) {
        ComponentUtil.setBorder(this.getControl(), width, color);
        return this;
    }

    public ComponentBuilder<T> borderWidth(int width) {
        ComponentUtil.setBorderWidth(this.getControl(), width);
        return this;
    }

    public ComponentBuilder<T> borderColor(Color color) {
        ComponentUtil.setBorderColor(this.getControl(), color);
        return this;
    }

    public ComponentBuilder<T> rounded() {
        return this.borderRadius();
    }

    public ComponentBuilder<T> borderRadius() {
        ComponentUtil.setBorderRadius(this.getControl());
        return this;
    }

    public ComponentBuilder<T> borderRadius(int borderRadius) {
        ComponentUtil.setBorderRadius(this.getControl(), borderRadius);
        return this;
    }

    public ComponentBuilder<T> primaryButton() {
        ComponentUtil.applyPrimaryButtonStyle(this.getControl());
        return this;
    }

    public ComponentBuilder<T> primaryButton2() {
        ComponentUtil.applyPrimaryButtonStyle2(this.getControl());
        return this;
    }

    public ComponentBuilder<T> primaryButton3() {
        ComponentUtil.applyPrimaryButtonStyle3(this.getControl());
        return this;
    }

    public ComponentBuilder<T> applyPrimaryButtonStyle3WithCustomDisableColors(Color disabledColor, Color disabledBackgroundColor, Color disabledBorderColor) {
        ComponentUtil.applyPrimaryButtonStyle3WithCustomDisableColors(this.getControl(), disabledColor, disabledBackgroundColor, disabledBorderColor);
        return this;
    }

    public ComponentBuilder<T> secondaryButton() {
        ComponentUtil.applySecondaryButtonStyle(this.getControl());
        return this;
    }

    public ComponentBuilder<T> applySecondaryButtonStyleWithCustomDisabledColor(Color secondaryButtonDisabledColor, Color secondaryButtonDisabledBackgroundColor) {
        ComponentUtil.applySecondaryButtonStyleWithCustomDisabledColor(this.getControl(), secondaryButtonDisabledColor, secondaryButtonDisabledBackgroundColor);
        return this;
    }

    public ComponentBuilder<T> primaryBadge() {
        ComponentUtil.applyPrimaryBadgeStyle(this.getControl());
        return this;
    }

    public ComponentBuilder<T> grayBadge() {
        ComponentUtil.applyGrayBadgeStyle(this.getControl());
        return this;
    }

    public ComponentBuilder<T> grayButton() {
        ComponentUtil.applyGrayButtonStyle(this.getControl());
        return this;
    }

    public ComponentBuilder<T> linkButton() {
        ComponentUtil.applyLinkButtonStyle(this.getControl());
        return this;
    }

    public ComponentBuilder<T> linkButtonWithCustomDisabledColor(Color themeColor) {
        ComponentUtil.applyLinkButtonStyleWithCustomDisabledColor(this.getControl(), themeColor);
        return this;
    }

    public ComponentBuilder<T> applyInfoMessageStyle() {
        ComponentUtil.applyInfoMessageStyle(this.getControl());
        return this;
    }

    public ComponentBuilder<T> cursorPointer() {
        ComponentUtil.setCursorPointer(this.getControl());
        return this;
    }

    public ComponentBuilder<T> cursorDefault() {
        ComponentUtil.setCursorDefault(this.getControl());
        return this;
    }

    public ComponentBuilder<T> cursor(int cursorType) {
        ComponentUtil.setCursor(this.getControl(), cursorType);
        return this;
    }

    public ComponentBuilder<T> addRole(ComponentRole role) {
        ComponentUtil.addRole(this.getControl(), role);
        return this;
    }

    public ComponentBuilder<T> defaultButton() {
        return this.addRole(ComponentRole.DEFAULT_BUTTON);
    }

    public ComponentBuilder<T> closeButton() {
        return this.addRole(ComponentRole.CLOSE_BUTTON);
    }

    public ComponentBuilder<T> submitButton() {
        ComponentEventUtil.submitOnClick(this.getControl());
        return this.addRole(ComponentRole.SUBMIT_BUTTON);
    }

    public ComponentBuilder<T> data(Object data) {
        ComponentUtil.setData((Widget)this.getControl(), data);
        return this;
    }

    public ComponentBuilder<T> data(String key, Object value) {
        ComponentUtil.setData((Widget)this.getControl(), key, value);
        return this;
    }

    public ComponentBuilder<T> className(String className) {
        ComponentUtil.setClassName((Widget)this.getControl(), className);
        return this;
    }

    public ComponentBuilder<T> classes(String ... classes) {
        ComponentUtil.setClasses((Widget)this.getControl(), classes);
        return this;
    }

    public ComponentBuilder<T> id(String id) {
        ComponentUtil.setId((Widget)this.getControl(), id);
        return this;
    }

    public ComponentBuilder<T> focusable() {
        return this.focusable(true);
    }

    public ComponentBuilder<T> focusable(boolean focusable) {
        ComponentUtil.setTabIndex(this.getControl(), focusable ? 0 : -1);
        return this;
    }

    public ComponentBuilder<T> tabIndex() {
        ComponentUtil.setTabIndex(this.getControl());
        return this;
    }

    public ComponentBuilder<T> tabIndex(int tabIndex) {
        ComponentUtil.setTabIndex(this.getControl(), tabIndex);
        return this;
    }

    public ComponentBuilder<T> addState(String text) {
        ComponentUtil.addStateAutoKey(this.getControl(), text);
        return this;
    }

    public ComponentBuilder<T> addState(String text, Image image) {
        ComponentUtil.addStateAutoKey(this.getControl(), text, image);
        return this;
    }

    public ComponentBuilder<T> addState(Object stateKey, String text) {
        ComponentUtil.addState(this.getControl(), stateKey, text);
        return this;
    }

    public ComponentBuilder<T> addState(Object stateKey, String text, Image image) {
        ComponentUtil.addState(this.getControl(), stateKey, text, image);
        return this;
    }

    public ComponentBuilder<T> switchState(Object stateKey) {
        ComponentUtil.switchState(this.getControl(), stateKey);
        return this;
    }

    public ComponentBuilder<T> switchState() {
        ComponentUtil.switchState(this.getControl());
        return this;
    }

    public ComponentBuilder<T> show() {
        ComponentUtil.show(this.getControl());
        return this;
    }

    public ComponentBuilder<T> hide() {
        ComponentUtil.hide(this.getControl());
        return this;
    }

    public ComponentBuilder<T> enable(boolean enabled) {
        this.getControl().setEnabled(enabled);
        return this;
    }

    public ComponentBuilder<T> enable() {
        this.getControl().setEnabled(true);
        return this;
    }

    public ComponentBuilder<T> disable() {
        this.getControl().setEnabled(false);
        return this;
    }

    public ComponentBuilder<T> onClick(Listener onClick) {
        ComponentEventUtil.onClick(this.control, onClick);
        return this;
    }

    public ComponentBuilder<T> onSelection(Listener onSelection) {
        ComponentEventUtil.onSelection(this.control, onSelection);
        return this;
    }

    public ComponentBuilder<T> autoSelect() {
        ComponentEventUtil.autoSelect(this.getControl());
        return this;
    }

    public ComponentBuilder<T> onMouseUp(Listener onMouseUp) {
        ComponentEventUtil.onMouseUp(this.getControl(), onMouseUp);
        return this;
    }

    public ComponentBuilder<T> stopPropagationOnSelection() {
        ComponentEventUtil.stopPropagationOnSelection((Widget)this.getControl());
        return this;
    }

    public ComponentBuilder<T> onChange(Listener onChange) {
        ComponentEventUtil.onChange(this.getControl(), onChange);
        return this;
    }

    public ComponentBuilder<T> onOptionChange(ComponentEventUtil.OptionChangeHandler onOptionChange) {
        ComponentEventUtil.onOptionChange(this.getControl(), onOptionChange);
        return this;
    }

    public ComponentBuilder<T> onSubmit(Listener onSubmit) {
        ComponentEventUtil.onSubmit(this.getControl(), onSubmit);
        return this;
    }

    public ComponentBuilder<T> onFocus(ComponentEventUtil.FocusEventListener onFocus) {
        ComponentEventUtil.onFocus(this.getControl(), onFocus);
        return this;
    }

    public ComponentBuilder<T> onBlur(ComponentEventUtil.FocusEventListener onFocus) {
        ComponentEventUtil.onBlur(this.getControl(), onFocus);
        return this;
    }

    public ComponentBuilder<T> mouseTrack(MouseTrackListener listener) {
        if (listener != null) {
            this.getControl().addMouseTrackListener(listener);
        }
        return this;
    }

    public ComponentBuilder<T> onMouseMove(MouseMoveListener listener) {
        if (listener != null) {
            this.getControl().addMouseMoveListener(listener);
        }
        return this;
    }

    public ComponentBuilder<T> onPaint(final ComponentEventUtil.PaintHandler onPaint) {
        if (onPaint != null) {
            this.getControl().addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent event) {
                    if (event.widget.isDisposed() || event.gc.isDisposed()) {
                        return;
                    }
                    onPaint.call(event, StyleUtil.setupGC(event.gc), ComponentBuilder.this.getControl());
                }
            });
        }
        return this;
    }

    public ComponentBuilder<T> onResize(Consumer<ControlEvent> listener) {
        if (listener != null) {
            this.getControl().addControlListener(ControlListener.controlResizedAdapter(event -> listener.accept((ControlEvent)event)));
        }
        return this;
    }

    public <Type extends Widget> ComponentBuilder<T> addTo(Set<Type> set) {
        set.add(this.control);
        this.control.addDisposeListener(event -> set.remove(this.control));
        return this;
    }

    private void setupMargin() {
        boolean isMarginSet;
        boolean bl = isMarginSet = this.marginTop != null || this.marginRight != null || this.marginBottom != null || this.marginLeft != null;
        if (!isMarginSet) {
            return;
        }
        Composite targetContainer = null;
        if (this.getControl() instanceof Composite) {
            targetContainer = (Composite)this.getControl();
        } else {
            targetContainer = ComponentUtil.createGridContainer(this.getControl().getParent());
            targetContainer.setLayoutData(this.getControl().getLayoutData());
            ComponentUtil.gridFillHorizontal(this.getControl());
            ComponentUtil.gridAlignCenter(this.getControl());
            ComponentUtil.gridAlignMiddle(this.getControl());
            this.getControl().setParent(targetContainer);
        }
        if (this.marginTop != null) {
            ComponentUtil.setMarginTop(targetContainer, this.marginTop);
        }
        if (this.marginRight != null) {
            ComponentUtil.setMarginRight(targetContainer, this.marginRight);
        }
        if (this.marginBottom != null) {
            ComponentUtil.setMarginBottom(targetContainer, this.marginBottom);
        }
        if (this.marginLeft != null) {
            ComponentUtil.setMarginLeft(targetContainer, this.marginLeft);
        }
    }

    public ComponentBuilder<T> customRender() {
        StyleUtil.customRender(this.getControl());
        return this;
    }

    public ComponentBuilder<T> autoSizeCanvas() {
        ComponentUtil.autoSizeCanvas(this.getControl());
        return this;
    }

    public T build() {
        T t = this.control;
        if (t instanceof Control) {
            Control aControl = (Control)t;
            this.setupMargin();
            if (ComponentDataUtil.shouldUseCustomRender((Widget)aControl)) {
                this.customRender();
            }
            this.autoSizeCanvas();
            if (ComponentUtil.isEnableAutoWidth(aControl)) {
                ComponentUtil.applyAutoWidth(aControl);
            }
        }
        return this.control;
    }

    public static interface ButtonBuilderProvider
    extends ComponentBuilderProvider<Button> {
        @Override
        public void build(ComponentBuilder<Button> var1);
    }

    public static interface ComponentBuilderProvider<ComponentType extends Widget> {
        public void build(ComponentBuilder<ComponentType> var1);
    }

    public static interface CompositeBuilderProvider
    extends ComponentBuilderProvider<Composite> {
        @Override
        public void build(ComponentBuilder<Composite> var1);
    }

    public static interface ControlBuilderProvider
    extends ComponentBuilderProvider<Control> {
        @Override
        public void build(ComponentBuilder<Control> var1);
    }

    public static interface WidgetBuilderProvider
    extends ComponentBuilderProvider<Widget> {
        @Override
        public void build(ComponentBuilder<Widget> var1);
    }
}

