/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.util;

import com.kms.katalon.composer.components.util.ComponentDataUtil;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.core.util.ArrayUtil;
import com.kms.katalon.core.util.ObjectUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuImpl;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ComponentFinder {
    public static final int NOT_FOUND_INDEX = -1;
    public static NextControlsProvider CHILDREN_PROVIDER = root -> {
        Object[] menus;
        Object[] items;
        Object modelElement;
        ArrayList<Widget> allChildren = new ArrayList<Widget>();
        if (root == null) {
            return allChildren;
        }
        Object[] children = (Widget[])ObjectUtil.invokeGet((Object)root, (String)"getChildren");
        if (ArrayUtils.isNotEmpty((Object[])children)) {
            ComponentFinder.collectWidget(allChildren, children);
        }
        if (ArrayUtils.isNotEmpty((Object[])(children = (Widget[])ObjectUtil.invokeGet((Object)root, (String)"children")))) {
            ComponentFinder.collectWidget(allChildren, children);
        }
        if ((modelElement = root.getData("modelElement")) != null) {
            Object modelMenu;
            Object modelChildren = ObjectUtil.getField((Object)modelElement, (String)"children");
            if (modelChildren != null && modelChildren instanceof List && !((List)modelChildren).isEmpty()) {
                ((List)modelChildren).forEach(modelChild -> {
                    List items;
                    if (modelChild instanceof MenuImpl && (items = (List)ObjectUtil.invokeGet((Object)modelChild, (String)"getChildren")) != null && !items.isEmpty()) {
                        items.forEach(item -> {
                            Widget widget = (Widget)ObjectUtil.getField((Object)item, (String)"widget");
                            if (widget != null) {
                                allChildren.add(widget);
                            }
                        });
                    }
                });
            }
            if ((modelMenu = ObjectUtil.getField((Object)modelElement, (String)"menu")) != null && ObjectUtil.hasField((Object)modelMenu, (String)"widget")) {
                allChildren.add((Widget)ObjectUtil.getField((Object)modelMenu, (String)"widget"));
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])(items = (Object[])ObjectUtil.invokeGet((Object)root, (String)"getItems")))) {
            ComponentFinder.collectWidget(allChildren, items);
        }
        if (ArrayUtils.isNotEmpty((Object[])(menus = (Widget[])ObjectUtil.getField((Object)root, (String)"menus")))) {
            ComponentFinder.collectWidget(allChildren, menus);
        }
        return allChildren;
    };
    public static NextControlsProvider PARENT_PROVIDER = root -> Arrays.asList(ControlUtil.getParent(root));

    public static <T extends Widget> WidgetFilter TypeAndTextFilter(Class<T> type, String text) {
        return control -> ComponentFinder.TypeFilter(type).test(control) && ComponentFinder.TextFilter(text).test(control);
    }

    public static <T extends Widget> WidgetFilter TextFilter(String text) {
        return control -> {
            boolean useRegExp;
            String controlText = StringUtils.defaultString((String)ComponentDataUtil.getAnyText(control)).trim();
            String trimmedText = StringUtils.defaultString((String)text).trim();
            boolean bl = useRegExp = trimmedText.startsWith("/") && trimmedText.endsWith("/");
            if (useRegExp) {
                trimmedText = trimmedText.substring(1, trimmedText.length() - 1);
                String pattern = MessageFormat.format("^{0}$", trimmedText);
                return controlText.matches(pattern);
            }
            return controlText.equals(trimmedText);
        };
    }

    public static <T extends Widget> WidgetFilter TypeFilter(Class<T> type) {
        return control -> type.isInstance(control);
    }

    private ComponentFinder() {
    }

    public static int findIndex(Widget parent, Widget control) {
        Widget[] children = ControlUtil.getChildren(parent);
        return ComponentFinder.findIndex(children, control);
    }

    public static int findIndex(Widget[] children, Widget control) {
        if (children == null || control == null) {
            return -1;
        }
        int i = 0;
        while (i < children.length) {
            if (children[i] == control) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static Widget getChildren(Widget parent, int index) {
        Widget[] children = ControlUtil.getChildren(parent);
        return children != null && index >= 0 && index < children.length ? children[index] : null;
    }

    public static Widget getNextElementSibling(Widget control) {
        Widget parent = ControlUtil.getParent(control);
        int index = ComponentFinder.findIndex(parent, control);
        return index >= 0 ? ComponentFinder.getChildren(parent, index + 1) : null;
    }

    public static Widget getPrevElementSibling(Widget control) {
        Widget parent = ControlUtil.getParent(control);
        int index = ComponentFinder.findIndex(parent, control);
        return ComponentFinder.getChildren(parent, index - 1);
    }

    public static Widget children(Widget control, int index) {
        Widget[] children = ControlUtil.getChildren(control);
        if (children == null || index < 0 || index >= children.length) {
            return null;
        }
        return children[index];
    }

    public static Widget firstChild(Widget control) {
        return ComponentFinder.children(control, 0);
    }

    public static Widget lastChild(Widget control) {
        Widget[] children = ControlUtil.getChildren(control);
        return ComponentFinder.children(control, children.length);
    }

    public static Shell findShell(String text) {
        Shell[] shells;
        Shell[] shellArray = shells = ShellManager.getMainShell().getDisplay().getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            if (ComponentFinder.TextFilter(text).test((Widget)shell)) {
                return shell;
            }
            ++n2;
        }
        return null;
    }

    public static <T extends Widget> T findByTypeAndText(Widget root, Class<T> type, String text) {
        List<Widget> foundElements = ComponentFinder.filter(root, control -> ComponentFinder.TypeAndTextFilter(type, text).test(control), true);
        return (T)((Widget)ArrayUtil.getFirst(foundElements));
    }

    public static Widget findByText(Widget root, String text) {
        List<Widget> foundElements = ComponentFinder.filter(root, control -> ComponentFinder.TextFilter(text).test(control), true);
        return (Widget)ArrayUtil.getFirst(foundElements);
    }

    public static <T extends Widget> T findByType(Widget root, Class<T> type) {
        List<Widget> foundElements = ComponentFinder.filter(root, control -> ComponentFinder.TypeFilter(type).test(control), true);
        return (T)((Widget)ArrayUtil.getFirst(foundElements));
    }

    public static <T extends Widget> Widget findParent(Widget root, Class<T> type) {
        return ComponentFinder.findParent(root, ComponentFinder.TypeFilter(type));
    }

    public static Widget findParent(Widget root, WidgetFilter filter) {
        return ComponentFinder.find(root, PARENT_PROVIDER, filter);
    }

    public static Widget find(Widget root, WidgetFilter filter) {
        return ComponentFinder.find(root, CHILDREN_PROVIDER, filter);
    }

    public static Widget find(Widget root, NextControlsProvider nextControlsProvider, WidgetFilter filter) {
        List<Widget> foundElements = ComponentFinder.filter(root, nextControlsProvider, filter, true);
        return !foundElements.isEmpty() ? foundElements.get(0) : null;
    }

    public static List<Widget> findAllByText(Widget root, String text) {
        return ComponentFinder.filter(root, control -> ComponentFinder.TextFilter(text).test(control), false);
    }

    public static <T extends Widget> List<T> findAllByType(Widget root, Class<T> type) {
        return ComponentFinder.filter(root, control -> ComponentFinder.TypeFilter(type).test(control), false);
    }

    public static List<Widget> findAll(Widget root, WidgetFilter filter) {
        return ComponentFinder.filter(root, filter, false);
    }

    public static List<Widget> findAll(Widget root, NextControlsProvider nextControlsProvider, WidgetFilter filter) {
        return ComponentFinder.filter(root, nextControlsProvider, filter, false);
    }

    public static List<Widget> filter(Widget root, WidgetFilter filter, boolean findFirst) {
        return ComponentFinder.filter(root, CHILDREN_PROVIDER, filter, findFirst);
    }

    private static List<Widget> filter(Widget root, NextControlsProvider nextControlsProvider, WidgetFilter filter, boolean findFirst) {
        return ComponentFinder.filter(root, nextControlsProvider, filter, findFirst, -1);
    }

    private static List<Widget> filter(Widget root, WidgetFilter filter, boolean findFirst, int level) {
        return ComponentFinder.filter(root, CHILDREN_PROVIDER, filter, findFirst, level);
    }

    private static List<Widget> filter(Widget root, NextControlsProvider nextControlsProvider, WidgetFilter filter, boolean findFirst, int level) {
        ArrayList<Widget> foundElements = new ArrayList<Widget>();
        if (ControlUtil.isDisposed(root)) {
            return foundElements;
        }
        if (level >= 0) {
            char[] buf = new char[level * 2];
            Arrays.fill(buf, 0, buf.length, '-');
            String prefix = new String(buf);
            String text = ComponentDataUtil.getAnyText(root);
            String previewText = text.substring(0, Math.min(text.length(), 50));
            String info = MessageFormat.format("{0}> {1} ({2})", prefix, root.toString(), previewText);
            System.out.println(info);
        }
        if (filter.test(root)) {
            foundElements.add(root);
            if (findFirst) {
                return foundElements;
            }
        }
        List<Widget> nextElements = nextControlsProvider.get(root);
        for (Widget element : nextElements) {
            foundElements.addAll(ComponentFinder.filter(element, nextControlsProvider, filter, findFirst, level >= 0 ? level + 1 : level));
            if (!findFirst || foundElements.isEmpty()) continue;
            return foundElements.subList(0, 1);
        }
        return foundElements;
    }

    public static void dumpElementTree(Widget root) {
        ComponentFinder.filter(root, (Widget control) -> false, false, 0);
    }

    public static void dumpElementTree() {
        ComponentFinder.dumpElementTree((Widget)Display.getCurrent().getActiveShell());
    }

    public static void dumpAllElementTrees() {
        Shell[] shells;
        Shell[] shellArray = shells = ShellManager.getMainShell().getDisplay().getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            ComponentFinder.dumpElementTree((Widget)shell);
            ++n2;
        }
    }

    public static List<Widget> collectWidget(List<Widget> destList, Object[] items) {
        if (destList == null) {
            destList = new ArrayList<Widget>();
        }
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (item != null && item instanceof Widget) {
                destList.add((Widget)item);
            }
            ++n2;
        }
        return destList;
    }

    public static interface ControlFinder {
        public Widget find(Shell var1);
    }

    public static interface DialogCallback {
        public void call(Shell var1);
    }

    public static interface DialogFinder {
        public Shell find(Timer var1);
    }

    public static interface NextControlsProvider {
        public List<Widget> get(Widget var1);
    }

    public static interface WidgetFilter {
        public boolean test(Widget var1);
    }
}

