/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.util;

import com.kms.katalon.composer.components.util.ComponentBuilder;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class MessageWithIconComponent {
    private Composite parent;
    private String message;
    private String imageKey;
    private Color backgroundColor;
    private Color borderColor;
    private Color textColor;
    private Composite messageComposite;
    private static final int BORDER_RADIUS = 4;
    private static final int BORDER_WIDTH = 1;
    private static final int ICON_SIZE = 16;

    public MessageWithIconComponent(Composite parent, String message, String imageKey, Color backgroundColor, Color borderColor, Color textColor) {
        this.parent = parent;
        this.message = message;
        this.imageKey = imageKey;
        this.backgroundColor = backgroundColor;
        this.borderColor = borderColor;
        this.textColor = textColor;
    }

    public Composite create() {
        this.messageComposite = ComponentBuilder.gridContainer(this.parent, 2).margin(8).fillHorizontal().backgroundMode(2).build();
        this.messageComposite.addPaintListener(e -> {
            GC gc = e.gc;
            Rectangle bounds = this.messageComposite.getBounds();
            gc.setAntialias(1);
            gc.setBackground(this.backgroundColor);
            gc.fillRoundRectangle(0, 0, bounds.width - 1, bounds.height - 1, 8, 8);
            gc.setForeground(this.borderColor);
            gc.setLineWidth(1);
            gc.drawRoundRectangle(0, 0, bounds.width - 1, bounds.height - 1, 8, 8);
        });
        ComponentBuilder.image(this.messageComposite, this.imageKey).size(16, 16).top().build();
        final Label messageLabel = new Label(this.messageComposite, 64);
        messageLabel.setText(this.message);
        messageLabel.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                messageLabel.setBackground(MessageWithIconComponent.this.backgroundColor);
                messageLabel.setForeground(MessageWithIconComponent.this.textColor);
            }
        });
        GridData resultLabelLayoutData = new GridData(4, 128, true, false, 1, 1);
        messageLabel.setLayoutData((Object)resultLabelLayoutData);
        return this.messageComposite;
    }

    public Composite getControl() {
        return this.messageComposite;
    }
}

