/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.util;

import com.kms.katalon.composer.components.util.FontUtil;
import java.util.Stack;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;

public class StyleContext {
    private static boolean isEnable;
    private static Color color;
    private static Stack<Color> colorStack;
    private static Color background;
    private static Stack<Color> backgroundStack;
    private static Font font;
    private static Stack<Font> fontStack;

    static {
        colorStack = new Stack();
        backgroundStack = new Stack();
        fontStack = new Stack();
    }

    public static void begin() {
        StyleContext.clean();
        isEnable = true;
    }

    public static void suspend() {
        isEnable = false;
    }

    public static void resume() {
        isEnable = true;
    }

    public static void end() {
        isEnable = false;
        StyleContext.clean();
    }

    public static void clean() {
        color = null;
        background = null;
        font = null;
        colorStack.clear();
        backgroundStack.clear();
        fontStack.clear();
    }

    public static boolean isEnable() {
        return isEnable;
    }

    public static void style(Control control) {
        if (!isEnable) {
            return;
        }
        if (StyleContext.getColor() != null) {
            control.setForeground(StyleContext.getColor());
        }
        if (StyleContext.getBackground() != null) {
            control.setBackground(StyleContext.getBackground());
        }
        if (StyleContext.getFont() != null) {
            control.setFont(StyleContext.getFont());
        }
        control.redraw();
    }

    public static Color getColor() {
        return color;
    }

    public static void setColor(Color color) {
        colorStack.add(StyleContext.color);
        StyleContext.color = color;
    }

    public static void prevColor() {
        color = !colorStack.isEmpty() ? colorStack.pop() : null;
    }

    public static Color getBackground() {
        return background;
    }

    public static void setBackground(Color background) {
        backgroundStack.add(StyleContext.background);
        StyleContext.background = background;
    }

    public static void prevBackground() {
        background = !backgroundStack.isEmpty() ? backgroundStack.pop() : null;
    }

    public static Font getFont() {
        return font;
    }

    public static void setFont(Font font) {
        fontStack.add(StyleContext.font);
        StyleContext.font = font;
    }

    public static void setFontSize(int fontSize) {
        Font currentFont = font;
        StyleContext.setFont(FontUtil.size(currentFont != null ? currentFont : FontUtil.REGULAR, fontSize));
    }

    public static void prevFont() {
        font = !fontStack.isEmpty() ? fontStack.pop() : null;
    }
}

