/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.viewer;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.viewer.FocusCellOwnerDrawHighlighterForMultiSelection;
import java.lang.reflect.Method;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.widgets.TreeItem;

public class CustomTreeViewerFocusCellManager
extends TreeViewerFocusCellManager {
    private FocusCellOwnerDrawHighlighterForMultiSelection cellHighlighter;
    private TreeViewer viewer;
    private int maxColumnIndex = 0;

    public CustomTreeViewerFocusCellManager(TreeViewer viewer, FocusCellOwnerDrawHighlighterForMultiSelection cellHighlighter) {
        super(viewer, (FocusCellHighlighter)cellHighlighter);
        this.cellHighlighter = cellHighlighter;
        this.viewer = viewer;
        this.maxColumnIndex = viewer.getTree().getColumnCount() - 1;
    }

    public void focusCell(ViewerCell focusCell) {
        if (focusCell == null) {
            return;
        }
        try {
            Method m = Class.forName("org.eclipse.jface.viewers.SWTFocusCellManager").getDeclaredMethod("setFocusCell", ViewerCell.class);
            boolean access = m.isAccessible();
            if (!access) {
                m.setAccessible(true);
            }
            m.invoke((Object)this, focusCell);
            m.setAccessible(access);
        }
        catch (Exception e) {
            LoggerSingleton.logError(e);
        }
    }

    public void focusNextCell() {
        ViewerCell nextCell;
        int nextCellIndex;
        ViewerCell focusCell = this.cellHighlighter.getFocusCell();
        if (focusCell == null) {
            return;
        }
        int cellIndex = focusCell.getColumnIndex();
        ViewerRow row = focusCell.getViewerRow();
        if (row == null) {
            return;
        }
        boolean isNextRow = cellIndex >= this.maxColumnIndex;
        int n = nextCellIndex = isNextRow ? this.maxColumnIndex - cellIndex : cellIndex + 1;
        if (isNextRow) {
            ViewerRow nextRow = row.getNeighbor(2, false);
            if (nextRow == null) {
                nextRow = row.getNeighbor(2, true);
            }
            if (nextRow == null) {
                return;
            }
            row = nextRow;
            this.viewer.getTree().setSelection((TreeItem)row.getItem());
        }
        if ((nextCell = row.getCell(nextCellIndex)) == null) {
            return;
        }
        this.focusCell(nextCell);
    }

    public void focusPreviousCell() {
        ViewerCell previousCell;
        int previousCellIndex;
        ViewerCell focusCell = this.cellHighlighter.getFocusCell();
        if (focusCell == null) {
            return;
        }
        int cellIndex = focusCell.getColumnIndex();
        ViewerRow row = focusCell.getViewerRow();
        if (row == null) {
            return;
        }
        boolean isPreviousRow = cellIndex - 1 < 0;
        int n = previousCellIndex = isPreviousRow ? this.maxColumnIndex : cellIndex - 1;
        if (isPreviousRow) {
            ViewerRow previousRow = row.getNeighbor(1, false);
            if (previousRow == null) {
                previousRow = row.getNeighbor(1, true);
            }
            if (previousRow == null) {
                return;
            }
            row = previousRow;
            this.viewer.getTree().setSelection((TreeItem)row.getItem());
        }
        if ((previousCell = row.getCell(previousCellIndex)) == null) {
            return;
        }
        this.focusCell(previousCell);
    }
}

