/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.license;

import com.auth0.jwt.interfaces.Claim;
import com.kms.katalon.crypto.LicenseHelper;
import com.kms.katalon.license.models.Feature;
import com.kms.katalon.license.models.License;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;

public class LicenseService {
    private static LicenseService serviceInstance;

    private LicenseService() {
    }

    public static LicenseService getInstance() {
        if (serviceInstance == null) {
            serviceInstance = new LicenseService();
        }
        return serviceInstance;
    }

    public License parseJws(String jws) throws InvalidKeySpecException, IOException, NoSuchAlgorithmException {
        return this.parseJws(jws, "-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAljznsPZafPzlRo+NyyVTb4ZJaLYtSghoi0lNDOEyHNJhROWi7roPcK0mMkVz+2tCE0OXL+Aps0IS5zHwTZpNMSu7t7IEgFUfUJ7ZSUNM1HGo/kcwJc4knBdK2Zi0QS0bu30VIp9zBmvtuGsxrGTfmV8TI091SHAQfWWJjD2UPfHxz0xeyGNwInSEjJhhV67Cl1r9RlrDUt5Ai2/r5s1AtFD/UDLHObAkGKY4CO7Ei/PnH8OJi9S6MtW5o6NWAjBY4qj1brUGl/IX46KRIny7zJ1zoVSsy8plBBGs9VFAyky7sq7fkjZFvbBw46PWWTFZCuSYeFiXul2IKTVLWaqE0wIDAQAB\n-----END PUBLIC KEY-----");
    }

    public License parseJws(String jws, String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        LicenseHelper licenseHelper = LicenseHelper.getInstance();
        Map<String, Claim> claims = licenseHelper.parseJws(jws, publicKey);
        return this.getLicenseFromClaims(claims, jws, publicKey);
    }

    public License parseJwsFromFile(String filename) throws InvalidKeySpecException, IOException, NoSuchAlgorithmException {
        String jws = new String(Files.readAllBytes(Paths.get(filename, new String[0])));
        return this.parseJws(jws);
    }

    private License getLicenseFromClaims(Map<String, Claim> claims, String jws, String publicKey) {
        License license = new License();
        license.setLicenseType(claims.get("licenseType").asString());
        license.setExpirationDate(claims.get("expirationDate").asDate());
        license.setRenewTime(claims.get("renewTime").asDate());
        license.setMachineId(claims.get("machineId").asString());
        Claim orgIdClaim = claims.get("organizationId");
        Long orgId = null;
        if (orgIdClaim != null) {
            orgId = claims.get("organizationId").asLong();
        }
        license.setOrganizationId(orgId);
        Claim testingClaim = claims.get("testing");
        if (testingClaim != null) {
            license.setTesting(claims.get("testing").asBoolean());
        } else {
            license.setTesting(false);
        }
        license.setFeatures(claims.get("features").asList(Feature.class));
        license.setJwtCode(jws);
        license.setPublicKey(publicKey);
        return license;
    }
}

