/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.license.models;

import com.kms.katalon.license.models.AuthenticationInfo;
import com.kms.katalon.license.models.AuthenticationToken;
import java.time.Instant;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class CombinedAuthenticationToken
extends AuthenticationInfo {
    private AuthenticationToken adminToken;
    private AuthenticationToken katOneToken;

    public AuthenticationToken getAdminToken() {
        return this.adminToken;
    }

    public void setAdminToken(AuthenticationToken adminToken) {
        this.adminToken = adminToken;
    }

    public AuthenticationToken getKatOneToken() {
        return this.katOneToken;
    }

    public void setKatOneToken(AuthenticationToken katOneToken) {
        this.katOneToken = katOneToken;
    }

    public CombinedAuthenticationToken(AuthenticationToken adminToken, AuthenticationToken katOneToken) {
        this.adminToken = adminToken;
        this.katOneToken = katOneToken;
    }

    public boolean isNotEmpty() {
        return this.isAdminNotEmpty();
    }

    public boolean isAdminNotEmpty() {
        return this.isNotEmpty(this.adminToken);
    }

    public boolean isKatOneNotEmpty() {
        return this.isNotEmpty(this.katOneToken);
    }

    private boolean isNotEmpty(AuthenticationToken token) {
        return token != null && token.isNotEmpty();
    }

    public boolean isTokenExpired() {
        AccessTokenInfo tokenInfoToCheckExpiration = null;
        if (this.isKatOneNotEmpty() && StringUtils.isNotBlank((CharSequence)this.katOneToken.getRefreshToken())) {
            tokenInfoToCheckExpiration = this.katOneToken.parseRefreshToken(AccessTokenInfo.class);
        } else if (this.isAdminNotEmpty()) {
            tokenInfoToCheckExpiration = this.adminToken.parseAccessToken(AccessTokenInfo.class);
        }
        if (Objects.nonNull(tokenInfoToCheckExpiration)) {
            Long expiredOn = tokenInfoToCheckExpiration.exp();
            return Objects.nonNull(expiredOn) && Instant.now().getEpochSecond() > expiredOn;
        }
        return false;
    }

    private record AccessTokenInfo(Long exp) {
    }
}

