/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

public class TextRenderingOptions {
    public static final String DOCUMENT_LANGUAGE_DEFAULT = "dflt";
    private final String documentLanguage;
    private final boolean glyphSubstitutionEnabled;

    public TextRenderingOptions() {
        this(DOCUMENT_LANGUAGE_DEFAULT, true);
    }

    public TextRenderingOptions(String documentLanguage, boolean glyphSubstitutionEnabled) {
        this.documentLanguage = documentLanguage;
        this.glyphSubstitutionEnabled = glyphSubstitutionEnabled;
    }

    public String getDocumentLanguage() {
        return this.documentLanguage;
    }

    public boolean isGlyphSubstitutionEnabled() {
        return this.glyphSubstitutionEnabled;
    }

    public TextRenderingOptions withDocumentLanguage(String documentLanguage) {
        return new TextRenderingOptions(documentLanguage, this.glyphSubstitutionEnabled);
    }

    public TextRenderingOptions withGlyphSubstitutionsEnabled(boolean glyphSubstitutionEnabled) {
        return new TextRenderingOptions(this.documentLanguage, glyphSubstitutionEnabled);
    }
}

