/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.utils;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.codehaus.groovy.eclipse.core.model.GroovyRuntime;
import org.codehaus.groovy.eclipse.refactoring.formatter.SemicolonRemover;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jdt.groovy.core.util.JavaConstants;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.corext.codemanipulation.AddUnimplementedConstructorsOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.AddUnimplementedMethodsOperation;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.refactoring.StubTypeContext;
import org.eclipse.jdt.internal.corext.refactoring.TypeContextChecker;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.text.edits.TextEdit;

public class GroovyTypeBuilder {
    private IPackageFragmentRoot root;
    private IPackageFragment pack;
    private IType enclosingType;
    private boolean addComments;
    private int modifiers;
    private String typeKind;
    private String typeName;
    private String superclass;
    private String[] interfaces;
    private boolean[] methodStubs;
    private CompilationUnit astRoot;
    private Set<String> existingImports;
    private ImportRewrite importsRewrite;

    public void setPackageFragmentRoot(IPackageFragmentRoot root) {
        this.root = root;
    }

    public void setPackageFragment(IPackageFragment pack) {
        this.pack = pack;
    }

    public void setEnclosingType(IType enclosingType) {
        this.enclosingType = enclosingType;
    }

    public void setAddComments(boolean addComments) {
        this.addComments = addComments;
    }

    public void setTypeFlags(int modifiers) {
        this.modifiers = modifiers;
    }

    public void setTypeKind(String typeKind) {
        this.typeKind = typeKind;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setSuper(String superclass) {
        this.superclass = superclass;
    }

    public void setFaces(String ... interfaces) {
        this.interfaces = interfaces;
    }

    public void setStubs(boolean ... methodStubs) {
        this.methodStubs = methodStubs;
    }

    public IType build(IProgressMonitor monitor) throws CoreException, InterruptedException {
        return this.build(monitor, null);
    }

    public IType build(IProgressMonitor monitor, BiConsumer<IType, IProgressMonitor> otherSteps) throws CoreException, InterruptedException {
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NewWizardMessages.NewTypeWizardPage_operationdesc, (int)10);
        IProject project = this.root.getJavaProject().getProject();
        if (!GroovyNature.hasGroovyNature((IProject)project)) {
            GroovyRuntime.addGroovyNature((IProject)project);
        }
        monitor.worked(1);
        if (this.pack == null) {
            this.pack = this.root.getPackageFragment("");
        }
        if (this.pack.exists()) {
            monitor.worked(1);
        } else {
            String packName = this.pack.getElementName();
            this.pack = this.root.createPackageFragment(packName, true, (IProgressMonitor)((SubMonitor)monitor).split(1));
        }
        if (this.superclass == null) {
            this.superclass = "script".equals(this.typeKind) ? "groovy.lang.Script" : "java.lang.Object";
        }
        ICompilationUnit connectedCU = null;
        try {
            TextSelection selection;
            IType createdType;
            IBuffer buffer;
            boolean needsSave;
            ICompilationUnit cu;
            boolean isInnerClass = this.enclosingType != null;
            String typeName = GroovyTypeBuilder.getTypeNameWithoutParameters(this.typeName);
            int indent = isInnerClass ? GroovyTypeBuilder.getIndentUsed((IJavaElement)this.enclosingType) + 1 : 0;
            String lineDelimiter = GroovyTypeBuilder.getLineDelimiterUsed((IJavaElement)(isInnerClass ? this.enclosingType : this.pack.getJavaProject()));
            if (!isInnerClass) {
                String unitContent;
                cu = this.pack.createCompilationUnit(GroovyTypeBuilder.getCompilationUnitName(typeName), "", false, (IProgressMonitor)((SubMonitor)monitor).split(2));
                needsSave = true;
                cu.becomeWorkingCopy((IProgressMonitor)((SubMonitor)monitor).split(1));
                connectedCU = cu;
                buffer = cu.getBuffer();
                String fileComment = null;
                String typeComment = null;
                String typeContent = "class " + typeName + " {}";
                if (this.addComments) {
                    fileComment = CodeGeneration.getFileComment((ICompilationUnit)cu, (String)lineDelimiter);
                    String comment = CodeGeneration.getTypeComment((ICompilationUnit)cu, (String)typeName, (String[])CharOperation.NO_STRINGS, (String)lineDelimiter);
                    if (GroovyTypeBuilder.isValidComment(comment)) {
                        typeComment = comment;
                    }
                }
                if ((unitContent = CodeGeneration.getCompilationUnitContent((ICompilationUnit)cu, (String)fileComment, typeComment, (String)typeContent, (String)lineDelimiter)) != null) {
                    ASTParser parser = ASTParser.newParser((int)JavaConstants.AST_LEVEL);
                    parser.setKind(8);
                    parser.setProject(this.pack.getJavaProject());
                    parser.setSource(unitContent.toCharArray());
                    parser.setUnitName(cu.getPath().toString());
                    CompilationUnit unit = (CompilationUnit)parser.createAST(null);
                    if ((this.pack.isDefaultPackage() || unit.getPackage() != null) && !unit.types().isEmpty()) {
                        buffer.setContents(unitContent);
                    }
                }
                if (buffer.getLength() == 0) {
                    StringBuilder content = new StringBuilder();
                    if (fileComment != null && !fileComment.isEmpty()) {
                        content.append(fileComment).append(lineDelimiter);
                    }
                    if (!this.pack.isDefaultPackage()) {
                        content.append("package ").append(this.pack.getElementName());
                    }
                    content.append(lineDelimiter).append(lineDelimiter);
                    if (typeComment != null && !typeComment.isEmpty()) {
                        content.append(typeComment).append(lineDelimiter);
                    }
                    content.append(typeContent);
                    buffer.setContents(content.toString());
                }
                this.captureImports(cu);
                this.addImport(JavaModelUtil.concatenateName((String)this.pack.getElementName(), (String)typeName));
                int index = unitContent.lastIndexOf(typeContent);
                if (index == -1) {
                    AbstractTypeDeclaration typeNode = (AbstractTypeDeclaration)this.astRoot.types().get(0);
                    int start = ((ASTNode)typeNode.modifiers().get(0)).getStartPosition();
                    int end = typeNode.getStartPosition() + typeNode.getLength();
                    buffer.replace(start, end - start, this.buildTypeStub(cu, lineDelimiter));
                } else {
                    buffer.replace(index, typeContent.length(), this.buildTypeStub(cu, lineDelimiter));
                }
                JavaModelUtil.reconcile((ICompilationUnit)cu);
                createdType = cu.getType(typeName);
            } else {
                String typeComment;
                cu = this.enclosingType.getCompilationUnit();
                needsSave = !cu.isWorkingCopy();
                cu.becomeWorkingCopy((IProgressMonitor)((SubMonitor)monitor).split(1));
                connectedCU = cu;
                this.captureImports(cu);
                IType[] topLevelTypes = cu.getTypes();
                int i = 0;
                int n = topLevelTypes.length;
                while (i < n) {
                    this.addImport(topLevelTypes[i].getFullyQualifiedName('.'));
                    ++i;
                }
                StringBuilder typeContent = new StringBuilder();
                if (this.addComments && GroovyTypeBuilder.isValidComment(typeComment = CodeGeneration.getTypeComment((ICompilationUnit)cu, (String)JavaModelUtil.concatenateName((String)this.enclosingType.getTypeQualifiedName('.'), (String)typeName), (String[])CharOperation.NO_STRINGS, (String)lineDelimiter))) {
                    typeContent.append(typeComment).append(lineDelimiter);
                }
                typeContent.append(this.buildTypeStub(cu, lineDelimiter));
                IJavaElement sibling = null;
                if (this.enclosingType.isEnum()) {
                    IField[] fields = this.enclosingType.getFields();
                    if (fields.length > 0) {
                        int i2 = 0;
                        int n2 = fields.length;
                        while (i2 < n2) {
                            if (!fields[i2].isEnumConstant()) {
                                sibling = fields[i2];
                                break;
                            }
                            ++i2;
                        }
                    }
                } else {
                    IJavaElement[] elems = this.enclosingType.getChildren();
                    if (elems.length > 0) {
                        sibling = elems[0];
                    }
                }
                createdType = this.enclosingType.createType(typeContent.toString(), sibling, false, (IProgressMonitor)((SubMonitor)monitor).split(2));
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            cu = createdType.getCompilationUnit();
            this.rewriteImports(false, (IProgressMonitor)((SubMonitor)monitor).split(1));
            JavaModelUtil.reconcile((ICompilationUnit)cu);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            this.captureImports(cu);
            this.buildTypeMembers(createdType, indent, (IProgressMonitor)((SubMonitor)monitor).split(1));
            if (otherSteps != null) {
                otherSteps.accept(createdType, (IProgressMonitor)((SubMonitor)monitor).split(1));
            } else {
                monitor.worked(1);
            }
            this.rewriteImports(true, (IProgressMonitor)((SubMonitor)monitor).split(1));
            JavaModelUtil.reconcile((ICompilationUnit)cu);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            buffer = cu.getBuffer();
            ISourceRange range = createdType.getSourceRange();
            String originalContent = buffer.getText(range.getOffset(), range.getLength());
            String formattedContent = CodeFormatterUtil.format((int)4, (String)originalContent, (int)indent, (String)lineDelimiter, (IJavaProject)this.pack.getJavaProject());
            formattedContent = Strings.trimLeadingTabsAndSpaces((String)formattedContent);
            buffer.replace(range.getOffset(), range.getLength(), formattedContent);
            if (!isInnerClass) {
                selection = new TextSelection(0, buffer.getLength());
            } else {
                JavaModelUtil.reconcile((ICompilationUnit)cu);
                range = createdType.getSourceRange();
                selection = new TextSelection(range.getOffset(), range.getLength());
            }
            TextEdit textEdit = new SemicolonRemover((ITextSelection)selection, (IDocument)new Document(buffer.getContents())).format();
            if (textEdit.hasChildren()) {
                cu.applyTextEdit(textEdit, (IProgressMonitor)((SubMonitor)monitor).split(1));
            } else {
                monitor.worked(1);
            }
            if (needsSave) {
                cu.commitWorkingCopy(true, (IProgressMonitor)((SubMonitor)monitor).split(1));
            } else {
                monitor.worked(1);
            }
            IType iType = createdType;
            return iType;
        }
        finally {
            this.astRoot = null;
            this.importsRewrite = null;
            this.existingImports = null;
            if (connectedCU != null) {
                connectedCU.discardWorkingCopy();
            }
        }
    }

    private String buildTypeStub(ICompilationUnit cu, String lineDelimiter) throws CoreException {
        StringBuilder typeStub;
        block49: {
            IType fCurrType;
            int groovyModifiers;
            block48: {
                typeStub = new StringBuilder();
                if (!"script".equals(this.typeKind)) break block48;
                if (!"groovy.lang.Script".equals(this.superclass)) {
                    typeStub.append("@").append(this.addImport("groovy.transform.BaseScript")).append(" ").append(this.addImport(this.superclass)).append(" self").append(lineDelimiter).append(lineDelimiter);
                }
                break block49;
            }
            if ("trait".equals(this.typeKind) && !"java.lang.Object".equals(this.superclass)) {
                typeStub.append("@").append(this.addImport("groovy.transform.SelfType")).append("(").append(this.addImport(this.superclass)).append(")").append(lineDelimiter);
            }
            if (Flags.isPackageDefault((int)this.modifiers)) {
                groovyModifiers = this.modifiers & 0xFFFFFFF8;
                typeStub.append("@").append(this.addImport("groovy.transform.PackageScope")).append(" ");
            } else {
                groovyModifiers = this.modifiers & 0xFFFFFFFE;
            }
            typeStub.append(Flags.toString((int)groovyModifiers));
            if (groovyModifiers != 0) {
                typeStub.append(" ");
            }
            if ("record".equals(this.typeKind)) {
                if (CompilerOptions.versionToJdkLevel((String)cu.getJavaProject().getOption("org.eclipse.jdt.core.compiler.compliance", true)) < 0x3C0000L) {
                    typeStub.append("@").append(this.addImport("groovy.transform.RecordType")).append(" class ").append(this.typeName);
                } else {
                    typeStub.append(this.typeKind).append(" ").append(this.typeName).append("()");
                }
            } else {
                typeStub.append(this.typeKind).append(" ").append(this.typeName);
            }
            if ("class".equals(this.typeKind) && !"java.lang.Object".equals(this.superclass)) {
                typeStub.append(" extends ");
                ITypeBinding binding = null;
                fCurrType = cu.getType(this.typeName);
                if (fCurrType != null) {
                    try {
                        binding = TypeContextChecker.resolveSuperClass((String)this.superclass, (IType)fCurrType, (StubTypeContext)TypeContextChecker.createSuperClassStubTypeContext((String)this.typeName, (IType)this.enclosingType, (IPackageFragment)this.pack));
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                if (binding != null) {
                    typeStub.append(this.addImport(binding));
                } else {
                    typeStub.append(this.addImport(this.superclass));
                }
            }
            if (DefaultGroovyMethods.asBoolean((Object[])this.interfaces)) {
                if ("interface".equals(this.typeKind)) {
                    typeStub.append(" extends ");
                } else {
                    typeStub.append(" implements ");
                }
                fCurrType = cu.getType(this.typeName);
                ITypeBinding[] bindings = fCurrType == null ? new ITypeBinding[this.interfaces.length] : TypeContextChecker.resolveSuperInterfaces((String[])this.interfaces, (IType)fCurrType, (StubTypeContext)TypeContextChecker.createSuperInterfaceStubTypeContext((String)this.typeName, (IType)this.enclosingType, (IPackageFragment)this.pack));
                int i = 0;
                int n = this.interfaces.length;
                while (i < n) {
                    ITypeBinding binding = bindings[i];
                    if (binding != null) {
                        typeStub.append(this.addImport(binding));
                    } else {
                        typeStub.append(this.addImport(this.interfaces[i]));
                    }
                    if (i < n - 1) {
                        typeStub.append(", ");
                    }
                    ++i;
                }
            }
            typeStub.append(" {").append(lineDelimiter);
            String templateID = "";
            switch (this.typeKind) {
                case "script": 
                case "class": 
                case "trait": {
                    templateID = "org.eclipse.jdt.ui.text.codetemplates.classbody";
                    break;
                }
                case "enum": {
                    templateID = "org.eclipse.jdt.ui.text.codetemplates.enumbody";
                    break;
                }
                case "interface": {
                    templateID = "org.eclipse.jdt.ui.text.codetemplates.interfacebody";
                    break;
                }
                case "@interface": {
                    templateID = "org.eclipse.jdt.ui.text.codetemplates.annotationbody";
                    break;
                }
                case "record": {
                    templateID = "org.eclipse.jdt.ui.text.codetemplates.recordbody";
                }
            }
            try {
                String typeBody = CodeGeneration.getTypeBody((String)templateID, (ICompilationUnit)cu, (String)this.typeName, (String)lineDelimiter);
                if (typeBody != null) {
                    typeStub.append(typeBody);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            typeStub.append("}").append(lineDelimiter);
        }
        return typeStub.toString();
    }

    private void buildTypeMembers(IType type, int indent, IProgressMonitor monitor) throws CoreException {
        boolean buildStaticVoidMain;
        if (this.methodStubs == null) {
            return;
        }
        boolean buildConstructors = this.methodStubs.length > 0 && this.methodStubs[0];
        boolean buildUnimplemented = this.methodStubs.length > 1 && this.methodStubs[1];
        boolean bl = buildStaticVoidMain = this.methodStubs.length > 2 && this.methodStubs[2];
        if (buildConstructors || buildUnimplemented) {
            monitor.beginTask("Create inherited methods", 2);
            ITypeBinding binding = ASTNodes.getTypeBinding((CompilationUnit)this.astRoot, (IType)type);
            if (binding != null) {
                AddUnimplementedMethodsOperation operation;
                if (buildUnimplemented) {
                    operation = new AddUnimplementedMethodsOperation(this.astRoot, binding, null, -1, false, true, false);
                    operation.setCreateComments(this.addComments);
                    operation.run((IProgressMonitor)((SubMonitor)monitor).split(1));
                    Arrays.stream(operation.getCreatedImports()).forEach(this::addImport);
                } else {
                    monitor.worked(1);
                }
                if (buildConstructors) {
                    Constructor ctor;
                    try {
                        ctor = ReflectionUtils.getConstructor(AddUnimplementedConstructorsOperation.class, (Class[])new Class[]{CompilationUnit.class, ITypeBinding.class, IMethodBinding[].class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Map.class});
                        operation = (AddUnimplementedConstructorsOperation)ReflectionUtils.invokeConstructor((Constructor)ctor, (Object[])new Object[]{this.astRoot, binding, null, -1, Boolean.FALSE, Boolean.TRUE, Boolean.FALSE, null});
                    }
                    catch (RuntimeException e) {
                        ctor = ReflectionUtils.getConstructor(AddUnimplementedConstructorsOperation.class, (Class[])new Class[]{CompilationUnit.class, ITypeBinding.class, IMethodBinding[].class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
                        operation = (AddUnimplementedConstructorsOperation)ReflectionUtils.invokeConstructor((Constructor)ctor, (Object[])new Object[]{this.astRoot, binding, null, -1, Boolean.FALSE, Boolean.TRUE, Boolean.FALSE});
                    }
                    operation.setOmitSuper(false);
                    operation.setCreateComments(this.addComments);
                    operation.run((IProgressMonitor)((SubMonitor)monitor).split(1));
                    Arrays.stream(operation.getCreatedImports()).forEach(this::addImport);
                } else {
                    monitor.worked(1);
                }
            }
        }
        if (buildStaticVoidMain) {
            String comment;
            monitor.beginTask("Create main method", 2);
            String endl = "\n";
            StringBuilder stub = new StringBuilder();
            if (this.addComments && (comment = CodeGeneration.getMethodComment((ICompilationUnit)type.getCompilationUnit(), (String)type.getTypeQualifiedName('.'), (String)"main", (String[])new String[]{"args"}, (String[])CharOperation.NO_STRINGS, (String)Signature.createTypeSignature((String)"void", (boolean)true), null, (String)"\n")) != null) {
                stub.append(comment).append("\n");
            }
            stub.append("static void main(args) {").append("\n");
            String content = CodeGeneration.getMethodBodyContent((ICompilationUnit)type.getCompilationUnit(), (String)type.getTypeQualifiedName('.'), (String)"main", (boolean)false, (String)"", (String)"\n");
            if (content != null && !content.isEmpty()) {
                String margin = CodeFormatterUtil.createIndentString((int)(indent + 1), (IJavaProject)type.getJavaProject());
                String source = Strings.changeIndent((String)content, (int)0, (IJavaProject)type.getJavaProject(), (String)margin, (String)"\n");
                stub.append(margin).append(source);
            }
            stub.append("\n").append("}");
            monitor.worked(1);
            JavaModelUtil.reconcile((ICompilationUnit)type.getCompilationUnit());
            IJavaElement sibling = type.getChildren().length > 0 ? type.getChildren()[0] : null;
            type.createMethod(stub.toString(), sibling, false, (IProgressMonitor)((SubMonitor)monitor).split(1));
        }
    }

    private void captureImports(ICompilationUnit cu) {
        ASTParser parser = ASTParser.newParser((int)JavaConstants.AST_LEVEL);
        parser.setKind(8);
        parser.setResolveBindings(true);
        parser.setFocalPosition(0);
        parser.setSource(cu);
        this.astRoot = (CompilationUnit)parser.createAST(null);
        this.importsRewrite = CodeStyleConfiguration.createImportRewrite((CompilationUnit)this.astRoot, (boolean)true);
        this.existingImports = this.astRoot.imports().stream().map(ASTNodes::asString).collect(Collectors.toSet());
    }

    private String addImport(String qualTypeName) {
        return this.importsRewrite.addImport(qualTypeName);
    }

    private String addImport(ITypeBinding typeBinding) {
        return this.importsRewrite.addImport(typeBinding);
    }

    private void rewriteImports(boolean removeUnused, IProgressMonitor monitor) throws CoreException {
        this.importsRewrite.getCompilationUnit().applyTextEdit(this.importsRewrite.rewriteImports(monitor), monitor);
    }

    private static boolean isValidComment(String template) {
        if (template != null) {
            IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
            scanner.setSource(template.toCharArray());
            try {
                int next = scanner.getNextToken();
                while (TokenScanner.isComment((int)next)) {
                    next = scanner.getNextToken();
                }
                return next == 158;
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
        }
        return false;
    }

    private static int getIndentUsed(IJavaElement element) {
        try {
            IBuffer buffer;
            IOpenable openable = element.getOpenable();
            if (openable instanceof ITypeRoot && (buffer = openable.getBuffer()) != null) {
                int offset;
                int i = offset = ((ISourceReference)element).getSourceRange().getOffset();
                while (i > 0 && !IndentManipulation.isLineDelimiterChar((char)buffer.getChar(i - 1))) {
                    --i;
                }
                return Strings.computeIndentUnits((String)buffer.getText(i, offset - i), (IJavaProject)element.getJavaProject());
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return 0;
    }

    private static String getLineDelimiterUsed(IJavaElement element) {
        try {
            return element.getOpenable().findRecommendedLineSeparator();
        }
        catch (JavaModelException ignore) {
            return Util.LINE_SEPARATOR;
        }
    }

    private static String getCompilationUnitName(String typeNameWithoutParameters) {
        return typeNameWithoutParameters + ".groovy";
    }

    private static String getTypeNameWithoutParameters(String typeNameWithParameters) {
        int angleBracketOffset = typeNameWithParameters.indexOf(60);
        if (angleBracketOffset == -1) {
            return typeNameWithParameters;
        }
        return typeNameWithParameters.substring(0, angleBracketOffset);
    }
}

