/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner.predicates;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner.predicates.IASTNodePredicate;

public class AssignmentAndCall
implements IASTNodePredicate {
    @Override
    public ASTNode evaluate(ASTNode input) {
        if (input instanceof ClosureExpression) {
            return input;
        }
        if (AssignmentAndCall.isAssignment(input) || AssignmentAndCall.isMethodCall(input)) {
            return input;
        }
        return null;
    }

    public static boolean isAssignment(ASTNode node) {
        if (node instanceof DeclarationExpression) {
            return true;
        }
        if (node instanceof BinaryExpression) {
            return true;
        }
        if (node instanceof PostfixExpression) {
            return true;
        }
        return node instanceof PrefixExpression;
    }

    public static boolean isMethodCall(ASTNode node) {
        if (node instanceof StaticMethodCallExpression) {
            return true;
        }
        return node instanceof MethodCallExpression;
    }
}

