/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.dialogs;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.preferences.internal.PreferencesRegistry;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PreferenceDialogBuilder {
    private Point size;
    private String selectedNode;
    private String dialogName;
    private int levelToExpand;
    private Shell shell;

    private PreferenceDialogBuilder() {
        this.setExpandLevel(1);
    }

    public static PreferenceDialogBuilder create() {
        PreferenceDialogBuilder instance = new PreferenceDialogBuilder();
        return instance;
    }

    public PreferenceDialogBuilder addDialogName(String dialogName) {
        this.setDialogName(dialogName);
        return this;
    }

    public PreferenceDialogBuilder addSelectedNode(String selectedNode) {
        this.setSelectedNode(selectedNode);
        return this;
    }

    public PreferenceDialogBuilder addSize(Point size) {
        this.setSize(size);
        return this;
    }

    public PreferenceDialogBuilder addLevelToExpandAll(int level) {
        this.setExpandLevel(level);
        return this;
    }

    public PreferenceDialogBuilder addShell(Shell shell) {
        this.setShell(shell);
        return this;
    }

    public PreferenceDialog build() {
        IEclipseContext eclipseContext = (IEclipseContext)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IEclipseContext.class);
        PreferencesRegistry preferencesRegistry = (PreferencesRegistry)ContextInjectionFactory.make(PreferencesRegistry.class, (IEclipseContext)eclipseContext);
        PreferenceManager pm = preferencesRegistry.getPreferenceManager("com.kms.katalon.preferences.ProjectSettingPages", ApplicationInfo.isPlatformStudio());
        PreferenceDialog dialog = new PreferenceDialog(this.getShell(), pm);
        dialog.setSelectedNode(this.getSelectedNode());
        dialog.create();
        dialog.getTreeViewer().setComparator(new ViewerComparator());
        dialog.getTreeViewer().expandToLevel(this.getLevelToExpandAll());
        dialog.getShell().setText(this.getDialogName());
        dialog.getShell().setSize(this.getSize());
        return dialog;
    }

    private Point getSize() {
        if (this.size == null) {
            this.size = new Point(400, 400);
        }
        return this.size;
    }

    private void setSize(Point size) {
        this.size = size;
    }

    private String getSelectedNode() {
        if (this.selectedNode == null) {
            this.selectedNode = "";
        }
        return this.selectedNode;
    }

    private void setSelectedNode(String selectedNode) {
        this.selectedNode = selectedNode;
    }

    private String getDialogName() {
        if (this.dialogName == null) {
            this.dialogName = "";
        }
        return this.dialogName;
    }

    private void setDialogName(String dialogName) {
        this.dialogName = dialogName;
    }

    private int getLevelToExpandAll() {
        return this.levelToExpand;
    }

    private void setExpandLevel(int expandLevel) {
        if (expandLevel <= 0) {
            throw new IllegalArgumentException("Level to expand all must be greater than zero.");
        }
        this.levelToExpand = expandLevel;
    }

    private Shell getShell() {
        if (this.shell == null) {
            this.shell = Display.getCurrent().getActiveShell();
        }
        return this.shell;
    }

    private void setShell(Shell shell) {
        this.shell = shell;
    }
}

