/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Shell;

public class ProgressMonitorDialogWithThread
extends ProgressMonitorDialog {
    private Thread thread;

    public ProgressMonitorDialogWithThread(Shell parent) {
        super(parent);
    }

    private void setThread(Thread thread) {
        this.thread = thread;
    }

    protected void cancelPressed() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
        }
        super.cancelPressed();
    }

    private void startThreadAndWait() {
        if (this.thread == null) {
            return;
        }
        this.thread.run();
        while (this.thread.isAlive()) {
        }
    }

    public <V> V runAndWait(Callable<V> callable) throws InterruptedException, InvocationTargetException {
        FutureTask<V> futureTask = new FutureTask<V>(callable);
        this.setThread(new Thread(futureTask));
        try {
            this.startThreadAndWait();
            return futureTask.get();
        }
        catch (ExecutionException e) {
            throw new InvocationTargetException(e);
        }
    }
}

