/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.dialogs;

import com.kms.katalon.composer.components.impl.constants.ComposerComponentsImplMessageConstants;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.constants.GlobalMessageConstants;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WarningKSEFeatureAccessDialog
extends AbstractDialog {
    private final int CONTAINER_WIDTH = 400;
    private final int CONTAINER_MARGIN = 15;
    private String message;
    private Text txtEmail;
    private String email;

    public WarningKSEFeatureAccessDialog(Shell shell, String message) {
        super(shell);
        this.message = message;
    }

    @Override
    public String getDialogTitle() {
        return ComposerComponentsImplMessageConstants.DIA_KSE_FEATURE_TITLE;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite body = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2).minWidth(400).fill().margin(15).build();
        ComponentBuilder.label((Composite)body).text(ComposerComponentsImplMessageConstants.MSG_KSE_FEATURE_CREATE_NEW_ACCOUNT).fillHorizontal().colSpan(2).build();
        ComponentBuilder.label((Composite)body).text(ComposerComponentsImplMessageConstants.MSG_KSE_FEATURE_ENTER_EMAIL).build();
        this.txtEmail = (Text)ComponentBuilder.text((Composite)body, (int)2048).fillHorizontal().onChange(event -> {
            String email = this.txtEmail.getText();
            boolean isEmailInputted = StringUtils.isNotBlank((String)email);
            this.getButton(0).setEnabled(isEmailInputted);
            if (email.endsWith("\n")) {
                this.txtEmail.setText(email.replaceAll("\r|\n", ""));
                this.okPressed();
            }
        }).build();
        body.pack();
        return body;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, GlobalMessageConstants.DIA_CANCEL, false);
        this.createButton(parent, 0, GlobalMessageConstants.DIA_OK, true);
        this.getButton(0).setEnabled(false);
        this.getShell().setDefaultButton(this.getButton(1));
        this.getShell().setDefaultButton(this.getButton(0));
    }

    protected void okPressed() {
        try {
            String encodedEmail = URLEncoder.encode(this.txtEmail.getText(), "UTF-8");
            String signUpUrl = MessageFormat.format(ComposerComponentsImplMessageConstants.URI_KATALON_SIGN_UP, encodedEmail);
            ComponentUtil.triggerLink((String)signUpUrl);
        }
        catch (UnsupportedEncodingException error) {
            LoggerSingleton.logError((Throwable)error);
        }
        this.email = this.txtEmail.getText();
        super.okPressed();
    }

    public String getEmail() {
        return this.email;
    }

    @Override
    protected void registerControlModifyListeners() {
    }

    @Override
    protected void setInput() {
    }

    @Override
    protected Control createDialogContainer(Composite parent) {
        return null;
    }
}

