/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.installer;

import com.kms.katalon.composer.components.impl.installer.StepStatusType;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class InstallationStep
implements IRunnableWithProgress {
    private String title;
    private File logFile;
    private File errorLogFile;
    private StepStatusType status;
    private IRunnableWithProgress before;
    private IRunnableWithProgress after;

    public InstallationStep(String title, File logFile, File errorLogFile) {
        this.title = title;
        this.setLogFile(logFile != null ? logFile : InstallationStep.createTempFile("InstallationLog"));
        this.setErrorLogFile(errorLogFile != null ? errorLogFile : InstallationStep.createTempFile("InstallationErrorLog"));
    }

    public InstallationStep(String title, File logFile) {
        this(title, logFile, null);
    }

    public InstallationStep(String title) {
        this(title, null, null);
    }

    private static File createTempFile(String name) {
        try {
            return File.createTempFile(name, ".log");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String name) {
        this.title = name;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void setLogFile(File logFile) {
        this.logFile = logFile;
    }

    public File getErrorLogFile() {
        return this.errorLogFile;
    }

    public void setErrorLogFile(File errorLogFile) {
        this.errorLogFile = errorLogFile;
    }

    public StepStatusType getStatus() {
        return this.status;
    }

    public boolean isError() {
        return this.status == StepStatusType.ERROR;
    }

    public boolean isWarning() {
        return this.status == StepStatusType.WARNING;
    }

    public void markAsSuccess() {
        this.status = StepStatusType.SUCCESS;
    }

    public void markAsError() {
        this.status = StepStatusType.ERROR;
    }

    public void markAsWarning() {
        this.status = StepStatusType.WARNING;
    }

    public IRunnableWithProgress getBefore() {
        return this.before;
    }

    public void setBefore(IRunnableWithProgress before) {
        this.before = before;
    }

    public IRunnableWithProgress getAfter() {
        return this.after;
    }

    public void setAfter(IRunnableWithProgress after) {
        this.after = after;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
    }
}

