/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.tree;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.tree.TooltipPropertyDescription;
import com.kms.katalon.entity.folder.FolderEntity;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;

public class KeywordTreeEntity
implements ITreeEntity {
    private static final long serialVersionUID = 8273934119859892617L;
    private static final String KEYWORD_TYPE_NAME = StringConstants.TREE_KEYWORD_TYPE_NAME;
    public static final String KEY_WORD = "kw";
    public static final String[] SEARCH_TAGS = new String[]{"name"};
    private ITreeEntity parentTreeEntity;
    private ICompilationUnit keywordFile;

    public KeywordTreeEntity(ICompilationUnit keywordFile, ITreeEntity parentTreeEntity) {
        this.parentTreeEntity = parentTreeEntity;
        this.keywordFile = keywordFile;
    }

    public Object getObject() throws Exception {
        return this.keywordFile;
    }

    public Object[] getChildren() throws Exception {
        return null;
    }

    public ITreeEntity getParent() throws Exception {
        return this.parentTreeEntity;
    }

    public String getText() throws Exception {
        return this.keywordFile.getElementName();
    }

    public Image getImage() throws Exception {
        return ImageConstants.IMG_16_KEYWORD;
    }

    public String getTypeName() throws Exception {
        return KEYWORD_TYPE_NAME;
    }

    public String getCopyTag() throws Exception {
        return FolderEntity.FolderType.KEYWORD.toString();
    }

    public boolean hasChildren() throws Exception {
        return false;
    }

    public boolean isRemoveable() throws Exception {
        return true;
    }

    public boolean isRenamable() throws Exception {
        return true;
    }

    public Transfer getEntityTransfer() throws Exception {
        return FileTransfer.getInstance();
    }

    public void setObject(Object object) throws Exception {
        if (object instanceof ICompilationUnit) {
            this.keywordFile = (ICompilationUnit)object;
        }
    }

    public String getKeyWord() throws Exception {
        return KEY_WORD;
    }

    public String[] getSearchTags() throws Exception {
        return SEARCH_TAGS;
    }

    public String getPropertyValue(String key) {
        if (key.equals("name")) {
            return this.keywordFile.getElementName();
        }
        return "";
    }

    public boolean equals(Object object) {
        KeywordTreeEntity anotherKeywordTreeEntity;
        block5: {
            block4: {
                try {
                    if (object instanceof KeywordTreeEntity) break block4;
                    return false;
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                    return false;
                }
            }
            anotherKeywordTreeEntity = (KeywordTreeEntity)object;
            if (anotherKeywordTreeEntity.getObject() instanceof ICompilationUnit) break block5;
            return false;
        }
        ICompilationUnit anotherKeywordFile = (ICompilationUnit)anotherKeywordTreeEntity.getObject();
        return StringUtils.equalsIgnoreCase((String)anotherKeywordFile.getPath().toString(), (String)this.keywordFile.getPath().toString());
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 31).append((Object)this.keywordFile.getPath().toString()).toHashCode();
    }

    public Image getEntryImage() throws Exception {
        return this.getImage();
    }

    public void loadAllDescentdantEntities() throws Exception {
    }

    public List<TooltipPropertyDescription> getTooltipDescriptions() {
        return Collections.emptyList();
    }
}

