/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.tree;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.tree.AbstractTreeEntity;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.tree.TooltipPropertyDescription;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.entity.Entity;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.report.ReportEntity;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;

public class ReportTreeEntity
extends AbstractTreeEntity {
    private static final long serialVersionUID = -5738894941424885826L;
    private static final String REPORT_TYPE_NAME = StringConstants.TREE_REPORT_TYPE_NAME;
    public static final String KEY_WORD = "rp";
    public static final String[] SEARCH_TAGS = new String[]{"id", "name"};
    private ReportEntity report;

    public ReportTreeEntity(ReportEntity report, ITreeEntity parentTreeEntity) {
        super((FileEntity)report, parentTreeEntity);
        this.report = report;
    }

    public ReportEntity getObject() throws Exception {
        this.report = ReportController.getInstance().reloadReport(this.report, (Entity)this.entity);
        return this.report;
    }

    public Object[] getChildren() throws Exception {
        return null;
    }

    public Image getImage() throws Exception {
        return ImageConstants.IMG_16_REPORT;
    }

    public String getTypeName() throws Exception {
        return REPORT_TYPE_NAME;
    }

    public String getCopyTag() throws Exception {
        return FolderEntity.FolderType.REPORT.toString();
    }

    public boolean hasChildren() throws Exception {
        return false;
    }

    public boolean isRemoveable() throws Exception {
        return true;
    }

    public boolean isRenamable() throws Exception {
        return true;
    }

    public Transfer getEntityTransfer() throws Exception {
        return null;
    }

    @Override
    public void setObject(Object object) throws Exception {
        if (object instanceof ReportEntity) {
            this.entity = (FileEntity)object;
            this.report = (ReportEntity)object;
        }
    }

    public String getKeyWord() throws Exception {
        return KEY_WORD;
    }

    public String[] getSearchTags() throws Exception {
        return SEARCH_TAGS;
    }

    public String getPropertyValue(String key) {
        if (key.equals("id")) {
            return this.report.getRelativePathForUI().replace(File.separator, "/");
        }
        if (key.equals("name")) {
            return this.report.getName();
        }
        return "";
    }

    public Image getEntryImage() throws Exception {
        return this.getImage();
    }

    public void loadAllDescentdantEntities() throws Exception {
    }

    @Override
    public List<TooltipPropertyDescription> getTooltipDescriptions() {
        return Collections.emptyList();
    }

    @Override
    public String getText() throws Exception {
        return this.report.getDisplayName();
    }
}

