/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.component;

import com.kms.katalon.ai.core.model.apigen.TestArtifactGenerationEndpoint;
import com.kms.katalon.composer.ai.component.ConnectivityStatus;
import com.kms.katalon.composer.ai.generation.dialogs.TestArtifactGenerationDialog;
import com.kms.katalon.composer.components.dialogs.TestGenerationCancellationDialog;
import com.kms.katalon.composer.components.impl.control.GifCLabel;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.logging.LogUtil;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Widget;

@Creatable
public class TestArtifactGenerationTaskProgressComponent {
    private final int BUTTON_WIDTH = SystemUtils.IS_OS_WINDOWS ? 100 : 150;
    private Composite parentContainer;
    private Composite container;
    private Label lblPercentCompleted;
    private ProgressBar progressBar;
    private Composite generationContainer;
    private Composite checkConnectionContainer;
    private GifCLabel checkConnectionIcon;
    private Label checkConnectionLabel;
    private Composite generatingContainer;
    private GifCLabel generatingIcon;
    private Label generatingLabel;
    private Composite errorContainer;
    private Label errorLabel;
    private Composite failedEndpointsContainer;
    private Composite resultContainer;
    private Label resultLabel;
    private Composite continueAnywayContainer;
    private Label continueLabel;
    private Button btnCancel;
    private Button btnHide;
    private Button btnContinueAnyway;
    private Button btnRetry;
    private TestArtifactGenerationDialog dialog;
    @Inject
    IEventBroker eventBroker;
    private Map<String, WebServiceRequestEntity> selectedEntities;
    private Map<String, TestArtifactGenerationEndpoint> completedEndpoints;
    private List<TestArtifactGenerationEndpoint> generatingEndpoints;
    private Map<String, TestArtifactGenerationEndpoint> generatedEndpoints = new HashMap<String, TestArtifactGenerationEndpoint>();

    public void setDialog(TestArtifactGenerationDialog dialog) {
        this.dialog = dialog;
    }

    public void createContent(Composite parent) {
        this.parentContainer = parent;
        this.container = (Composite)ComponentBuilder.gridContainer((Composite)this.parentContainer).gridVerticalSpacing(10).fillHorizontal().marginRight(10).marginLeft(10).height(475).build();
        this.createProgressBar(this.container);
        Composite mainContainer = (Composite)ComponentBuilder.gridContainer((Composite)this.container).fill().build();
        this.generationContainer = (Composite)ComponentBuilder.gridContainer((Composite)mainContainer).activeBackground(ColorUtil.themeColor((Color)ColorUtil.getWhiteBackgroundColor(), (Color)ColorUtil.getColor((String)"#2F2E2F"))).background(ColorUtil.themeColor((Color)ColorUtil.getWhiteBackgroundColor(), (Color)ColorUtil.getColor((String)"#2F2E2F"))).color(ColorUtil.themeColor((Color)ColorUtil.getTextBlackColor(), (Color)ColorUtil.getTextWhiteColor())).backgroundMode(2).fill().height(225).build();
        this.checkConnectionContainer = (Composite)ComponentBuilder.gridContainer((Composite)this.generationContainer).gridLayout(2, false).fillHorizontal().marginTop(5).build();
        this.checkConnectionIcon = new GifCLabel(this.checkConnectionContainer, 0x20000000);
        this.checkConnectionIcon.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        String image = ColorUtil.isDarkTheme() ? "loading_roll_darktheme.gif" : "loading_roll.gif";
        this.setLabelIcon(this.checkConnectionIcon, image);
        this.checkConnectionLabel = (Label)ComponentBuilder.label((Composite)this.checkConnectionContainer).text("Checking internet connection.").build();
        this.generatingContainer = (Composite)ComponentBuilder.gridContainer((Composite)this.generationContainer).gridLayout(2, false).build();
        this.generatingIcon = new GifCLabel(this.generatingContainer, 0x20000000);
        this.generatingIcon.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.setLabelIcon(this.generatingIcon, image);
        this.generatingLabel = (Label)ComponentBuilder.label((Composite)this.generatingContainer).color(ColorUtil.themeColor((Color)ColorUtil.getTextBlackColor(), (Color)ColorUtil.getTextWhiteColor())).activeColor(ColorUtil.getTextErrorColor()).text("Generating test scripts for endpoints.").build();
        this.generatingLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.errorContainer = (Composite)ComponentBuilder.gridContainer((Composite)this.generationContainer).marginLeft(32).build();
        this.errorContainer.setVisible(false);
        this.errorLabel = (Label)ComponentBuilder.label((Composite)this.errorContainer).fontSize(10).text("Errors have occurred when generating tests for the following endpoints:").activeColor(ColorUtil.getTextErrorColor()).color(ColorUtil.getTextErrorColor()).build();
        this.failedEndpointsContainer = (Composite)ComponentBuilder.gridContainer((Composite)this.errorContainer).gridLayout(2, false).build();
        this.createResultLine(this.container);
        this.createContinueAnywayComposite(this.container);
        this.createButtonBar(this.container);
    }

    public void show() {
        ComponentUtil.show((Control)this.parentContainer);
    }

    public void hide() {
        ComponentUtil.hide((Control)this.parentContainer);
    }

    public void dispose() {
        this.parentContainer.dispose();
    }

    public int confirmClosing() {
        Integer noGeneratedTestCases = this.completedEndpoints.values().stream().reduce(0, (acc, e) -> acc + e.getTestCases().size(), Integer::sum);
        TestGenerationCancellationDialog dialog = null;
        if (noGeneratedTestCases == 0) {
            dialog = new TestGenerationCancellationDialog();
        } else {
            String message = MessageFormat.format("{0} test cases generated successfully. Are you sure you want to cancel the generating process?", noGeneratedTestCases);
            dialog = new TestGenerationCancellationDialog(message, true);
        }
        return dialog.open();
    }

    public void setConnectivitystatus(ConnectivityStatus status) {
        switch (status) {
            case CHECKING: {
                String image = ColorUtil.isDarkTheme() ? "loading_roll_darktheme.gif" : "loading_roll.gif";
                this.setLabelIcon(this.checkConnectionIcon, image);
                break;
            }
            case CONNECTED: {
                this.setLabelIcon(this.checkConnectionIcon, "genai/done_small.png");
                break;
            }
            case DISCONNECTED: {
                this.setLabelIcon(this.checkConnectionIcon, "genai/error.png");
                this.setConnectionError("Please check your Internet connection and try again.");
                ComponentUtil.show((Control)this.btnRetry);
                ComponentUtil.hide((Control)this.btnHide);
                this.dialog.getShell().setDefaultButton(this.btnRetry);
                break;
            }
        }
    }

    public void setGenerationFailedStatus() {
        this.progressBar.setForeground(ColorUtil.getColor((String)"#D24720"));
        this.setLabelIcon(this.generatingIcon, "genai/error.png");
        ComponentUtil.setColor((Control)this.generatingLabel, (Color)ColorUtil.getTextErrorColor());
        ComponentUtil.setText((Widget)this.errorLabel, (String)"Errors have occurred when generating test scripts.");
        ComponentUtil.show((Control)this.errorContainer);
        ComponentUtil.hide((Control)this.btnHide);
        ComponentUtil.show((Control)this.btnRetry);
        this.dialog.getShell().setDefaultButton(this.btnRetry);
    }

    public void setEndpoints(List<TestArtifactGenerationEndpoint> endpoints, List<WebServiceRequestEntity> selectedEntities, Map<String, TestArtifactGenerationEndpoint> completedEndpoints) {
        this.selectedEntities = new HashMap<String, WebServiceRequestEntity>();
        selectedEntities.forEach(e -> {
            String id = MessageFormat.format("{0} {1}", e.getRestRequestMethod(), e.getPath());
            this.selectedEntities.put(id, (WebServiceRequestEntity)e);
        });
        this.completedEndpoints = completedEndpoints;
        this.generatingEndpoints = endpoints;
        this.generatedEndpoints = new HashMap<String, TestArtifactGenerationEndpoint>();
        this.updateGeneratedTestCasesText();
    }

    public void updateEndpointStatus(TestArtifactGenerationEndpoint endpoint) {
        this.generatedEndpoints.put(endpoint.getId(), endpoint);
        this.updateGeneratedTestCasesText();
        if (endpoint.isFailed()) {
            String entityId = MessageFormat.format("{0} {1}", endpoint.getMethod(), endpoint.getPath());
            WebServiceRequestEntity entity = this.selectedEntities.get(entityId);
            ComponentBuilder.label((Composite)this.failedEndpointsContainer).image(this.getImageByMethod(entity.getRestRequestMethod())).build();
            List testCases = endpoint.getTestCases();
            int noTestCases = testCases != null ? testCases.size() : 0;
            String testCaseText = MessageFormat.format("{0} ({1}) ", entity.getName(), noTestCases);
            ComponentBuilder.label((Composite)this.failedEndpointsContainer).text(testCaseText).fontSize(10).build();
            this.errorContainer.setVisible(true);
        }
        this.resultContainer.setVisible(true);
        int total = this.generatingEndpoints.size();
        int completed = this.generatedEndpoints.size();
        int percent = completed * 100 / total;
        this.setProgressStatus(percent, 0);
        if (this.generatingEndpoints.size() == this.generatedEndpoints.size()) {
            this.completeGeneration();
        }
    }

    private void setLabelIcon(GifCLabel label, String imageUrl) {
        InputStream imageStream = null;
        try {
            try {
                imageStream = ImageManager.getImageURL((String)imageUrl).openStream();
                label.setGifImage(imageStream);
            }
            catch (IOException e) {
                LogUtil.logError((Throwable)e, (String)("Cannot load image: " + imageUrl));
                if (imageStream != null) {
                    IOUtils.closeQuietly((InputStream)imageStream);
                }
            }
        }
        finally {
            if (imageStream != null) {
                IOUtils.closeQuietly((InputStream)imageStream);
            }
        }
    }

    private void setConnectionError(String error) {
        ComponentUtil.setText((Widget)this.checkConnectionLabel, (String)error);
        ComponentUtil.setColor((Control)this.checkConnectionLabel, (Color)ColorUtil.getTextErrorColor());
    }

    private void setProgressStatus(int percent, int state) {
        ComponentUtil.setText((Widget)this.lblPercentCompleted, (String)MessageFormat.format("{0}%", percent));
        this.progressBar.setSelection(percent);
        this.progressBar.setState(state);
    }

    private String getImageByMethod(String method) {
        switch (method) {
            case "GET": {
                return "entity/ws_get_16.png";
            }
            case "POST": {
                return "entity/ws_post_16.png";
            }
            case "PUT": {
                return "entity/ws_put_16.png";
            }
            case "DELETE": {
                return "entity/ws_delete_16.png";
            }
            case "PATCH": {
                return "entity/ws_patch_16.png";
            }
            case "CONNECT": {
                return "entity/ws_connect_16.png";
            }
            case "HEAD": {
                return "entity/ws_head_16.png";
            }
            case "OPTIONS": {
                return "entity/ws_options_16.png";
            }
            case "TRACE": {
                return "entity/ws_trace_16.png";
            }
        }
        return "entity/ws_custom_16.png";
    }

    private void createProgressBar(Composite parent) {
        int percentWidth = SystemUtils.IS_OS_WINDOWS ? 30 : 50;
        Composite cpInfoMessage = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2).fillHorizontal().build();
        ComponentBuilder.label((Composite)cpInfoMessage).text("Applying AI to generate web services test cases").fillHorizontal().left().build();
        this.lblPercentCompleted = (Label)ComponentBuilder.label((Composite)cpInfoMessage).fillHorizontal().right().text("0%").minWidth(ComponentUtil.applyZoom((int)percentWidth)).build();
        this.progressBar = new ProgressBar(parent, 65536);
        GridData gd = new GridData();
        gd.heightHint = 9;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.progressBar.setLayoutData((Object)gd);
    }

    private void createResultLine(Composite parent) {
        this.resultContainer = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2).background(ColorUtil.getColor((String)"#EFF4FD")).backgroundMode(2).margin(15).fillHorizontal().build();
        ComponentBuilder.label((Composite)this.resultContainer).image("info_16.png").build();
        this.resultLabel = (Label)ComponentBuilder.label((Composite)this.resultContainer).color(ColorUtil.getColor((String)"#273A60")).middle().build();
    }

    private void createContinueAnywayComposite(Composite parentContainer) {
        this.continueAnywayContainer = (Composite)ComponentBuilder.gridContainer((Composite)parentContainer).hide().build();
        this.continueLabel = (Label)ComponentBuilder.label((Composite)this.continueAnywayContainer).marginTop(15).build();
    }

    private void createButtonBar(Composite parent) {
        Composite cpButtons = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2).background(ColorUtil.GRAY_COLOR).fillHorizontal().marginTop(10).marginBottom(20).marginRight(10).build();
        Composite leftButtons = (Composite)ComponentBuilder.gridContainer((Composite)cpButtons, (int)2).fillHorizontal().bottom().left().build();
        this.btnContinueAnyway = (Button)ComponentBuilder.button((Composite)leftButtons).text("Continue anyway").width(ComponentUtil.applyZoom((int)this.BUTTON_WIDTH)).hide().onClick(event -> this.dialog.continueSavingTests()).build();
        Composite rightButtons = (Composite)ComponentBuilder.gridContainer((Composite)cpButtons, (int)2).fillHorizontal().bottom().right().build();
        this.btnCancel = (Button)ComponentBuilder.button((Composite)rightButtons).text("Cancel").width(ComponentUtil.applyZoom((int)this.BUTTON_WIDTH)).onClick(event -> {
            int result = this.confirmClosing();
            if (result == 1) {
                this.dialog.cancelGeneration();
            } else if (result == 16) {
                this.dialog.continueSavingTests();
            }
        }).build();
        this.btnHide = (Button)ComponentBuilder.button((Composite)rightButtons).text("Hide").width(ComponentUtil.applyZoom((int)this.BUTTON_WIDTH)).onClick(event -> this.dialog.hideDialog()).defaultButton().build();
        this.btnRetry = (Button)ComponentBuilder.button((Composite)rightButtons).onClick(event -> this.dialog.retryGeneration()).hide().text("Retry").width(ComponentUtil.applyZoom((int)this.BUTTON_WIDTH)).defaultButton().build();
    }

    private void updateGeneratedTestCasesText() {
        Integer noGeneratedTestCases = this.completedEndpoints.values().stream().reduce(0, (acc, e) -> acc + e.getTestCases().size(), Integer::sum);
        String testCaseText = MessageFormat.format("{0} test cases generated for {1} endpoints.", noGeneratedTestCases, this.selectedEntities.size());
        ComponentUtil.setText((Widget)this.resultLabel, (String)testCaseText);
        String continueText = MessageFormat.format("Continue anyway with {0} generated test cases or Retry with failed endpoints.", noGeneratedTestCases);
        ComponentUtil.setText((Widget)this.continueLabel, (String)continueText);
    }

    private void completeGeneration() {
        Integer noGeneratedTestCases = this.completedEndpoints.values().stream().reduce(0, (acc, e) -> acc + e.getTestCases().size(), Integer::sum);
        List<TestArtifactGenerationEndpoint> failedEndpoints = this.generatedEndpoints.values().stream().filter(e -> e.isFailed()).toList();
        if (failedEndpoints.size() > 0) {
            Color red = this.progressBar.getDisplay().getSystemColor(3);
            this.progressBar.setForeground(red);
            ComponentUtil.setColor((Control)this.generatingLabel, (Color)ColorUtil.getTextErrorColor());
            this.setLabelIcon(this.generatingIcon, "genai/error.png");
            ComponentUtil.setText((Widget)this.btnContinueAnyway, (String)"Continue anyway");
            ComponentUtil.show((Control)this.continueAnywayContainer);
            ComponentUtil.show((Control)this.btnRetry);
            this.dialog.getShell().setDefaultButton(this.btnRetry);
        } else {
            this.setLabelIcon(this.generatingIcon, "genai/done_small.png");
            ComponentUtil.setText((Widget)this.btnContinueAnyway, (String)"Continue");
        }
        ComponentUtil.hide((Control)this.btnHide);
        if (noGeneratedTestCases != 0) {
            ComponentUtil.show((Control)this.btnContinueAnyway);
        } else {
            ComponentUtil.setText((Widget)this.continueLabel, (String)"No test cases were generated, please retry.");
        }
    }
}

