/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.services;

import com.kms.katalon.ai.core.model.config.AiAutoTagConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistAvailabilityException;
import com.kms.katalon.ai.core.model.exception.StudioAssistBaseException;
import com.kms.katalon.ai.core.model.exception.StudioAssistConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistUnavailableException;
import com.kms.katalon.ai.core.model.llm.UserMessage;
import com.kms.katalon.ai.core.model.prompt.PromptType;
import com.kms.katalon.ai.core.services.IStringTemplateEngine;
import com.kms.katalon.ai.core.services.IStudioAssistController;
import com.kms.katalon.ai.core.services.IStudioAssistService;
import com.kms.katalon.core.setting.IStudioAssistAiAutoTagSetting;
import com.kms.katalon.session.core.model.AiAutoTagPolicyType;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import jakarta.inject.Inject;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

@Creatable
public class StudioAssistController
implements IStudioAssistController {
    @Inject
    @Optional
    public IStudioAssistService service;
    @Inject
    @Optional
    private IStringTemplateEngine templateEngine;
    @Inject
    private IFeatureController featureController;

    /*
     * WARNING - void declaration
     */
    public boolean isEnabled() {
        void textSelection;
        void textEditor;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IEditorPart editor = window.getActivePage().getActiveEditor();
        if (!(editor instanceof ITextEditor)) {
            return false;
        }
        ITextEditor iTextEditor = (ITextEditor)editor;
        ISelection selection = textEditor.getSelectionProvider().getSelection();
        if (!(selection instanceof ITextSelection)) {
            return false;
        }
        ITextSelection iTextSelection = (ITextSelection)selection;
        return textSelection.getText().length() != 0;
    }

    public boolean canExecute() throws StudioAssistConfigException, StudioAssistAvailabilityException {
        if (this.service == null || !this.featureController.canUse(ProductFeature.STUDIOASSIST_EXECUTE_PROMPT)) {
            throw new StudioAssistUnavailableException();
        }
        return this.service.canExecute();
    }

    public String executePrompt(PromptType promptType, List<UserMessage> messages) throws StudioAssistBaseException {
        return this.service.executePrompt(promptType, messages);
    }

    public StudioAssistConfig getConfig() throws StudioAssistLoadingConfigException {
        return this.service.getConfig();
    }

    public void saveConfig(StudioAssistConfig config) throws StudioAssistSavingConfigException {
        this.service.saveConfig(config);
    }

    public String getDefaultPromptContentTemplate(PromptType promptType) {
        return this.service.getDefaultPromptContentTemplate(promptType);
    }

    public String getPromptContentTemplate(PromptType promptType) {
        return this.service.getPromptContentTemplate(promptType);
    }

    public void savePromptContentTemplate(PromptType promptType, String promptContent) throws StudioAssistBaseException {
        this.service.savePromptContentTemplate(promptType, promptContent);
    }

    public List<String> getSupportedContextTemplateList(PromptType promptType) {
        return this.service.getSupportedContextVariables(promptType);
    }

    public String getRegexStringTemplateEngine() {
        return "\\$\\{(.*?)}";
    }

    public String buildVariableNameWithStringTemplate(String variableName) {
        return this.templateEngine.buidVariableNameWithStringTemplate(variableName);
    }

    public List<String> getRequiredVariablesForContextTemplate(PromptType promptType) {
        return this.getSupportedContextTemplateList(promptType);
    }

    public IStudioAssistAiAutoTagSetting getStudioAssistAiAutoTagSetting() {
        return this.service.getStudioAssistAiAutoTagSetting();
    }

    public void saveStudioAssistAiAutoTagSetting(AiAutoTagConfig aiAutoTagSetting) throws StudioAssistSavingConfigException {
        this.service.saveStudioAssistAiAutoTagSetting(aiAutoTagSetting);
    }

    @Inject
    @Optional
    private void setAiAutoTagSettingPolicy(@UIEventTopic(value="STUDIOASSIST/AI_AUTO_TAG_SETTING_POLICY_SET") Object data) {
        if (data instanceof AiAutoTagPolicyType) {
            AiAutoTagPolicyType policyType = (AiAutoTagPolicyType)data;
            this.service.setAiAutoTagSettingPolicy(policyType);
        }
    }
}

