/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.services;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import jakarta.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

@Creatable
@Singleton
public class TextSelectionService {
    /*
     * WARNING - void declaration
     */
    public String getFocusingFileContent(IWorkbenchWindow window) {
        void textEditor;
        IEditorPart editor = window.getActivePage().getActiveEditor();
        if (!(editor instanceof ITextEditor)) {
            return "";
        }
        ITextEditor iTextEditor = (ITextEditor)editor;
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        IDocument document = documentProvider.getDocument((Object)textEditor.getEditorInput());
        return document.get();
    }

    /*
     * WARNING - void declaration
     */
    public String getSelectedTexts(IWorkbenchWindow window) {
        void textSelection;
        void textEditor;
        IEditorPart editor = window.getActivePage().getActiveEditor();
        if (!(editor instanceof ITextEditor)) {
            return "";
        }
        ITextEditor iTextEditor = (ITextEditor)editor;
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        IDocument document = documentProvider.getDocument((Object)textEditor.getEditorInput());
        ISelection selection = textEditor.getSelectionProvider().getSelection();
        if (!(selection instanceof ITextSelection)) {
            return "";
        }
        ITextSelection iTextSelection = (ITextSelection)selection;
        StringBuilder result = new StringBuilder();
        int startLine = textSelection.getStartLine();
        int endLine = textSelection.getEndLine();
        int i = startLine;
        while (i <= endLine) {
            try {
                String lineText = document.get(document.getLineOffset(i), document.getLineLength(i)).trim() + "\n";
                if (lineText != null && !lineText.isEmpty() && lineText != "") {
                    result.append(lineText);
                }
            }
            catch (BadLocationException error) {
                LoggerSingleton.logError((Throwable)error);
            }
            ++i;
        }
        return result.toString();
    }

    public void insertCodeIntoEditor(String code, IWorkbenchWindow window) {
        UISynchronizeService.asyncExec(() -> {
            void textSelection;
            void textEditor;
            IEditorPart editor = window.getActivePage().getActiveEditor();
            if (!(editor instanceof ITextEditor)) {
                return;
            }
            ITextEditor iTextEditor = (ITextEditor)editor;
            IDocumentProvider documentProvider = textEditor.getDocumentProvider();
            IDocument document = documentProvider.getDocument((Object)textEditor.getEditorInput());
            ISelection selection = textEditor.getSelectionProvider().getSelection();
            if (!(selection instanceof ITextSelection)) {
                return;
            }
            ITextSelection iTextSelection = (ITextSelection)selection;
            int offset = textSelection.getOffset();
            int length = textSelection.getLength();
            try {
                document.replace(offset + length, 0, code);
                return;
            }
            catch (BadLocationException error) {
                LoggerSingleton.logError((Throwable)error);
                return;
            }
        });
    }
}

