/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.dialog;

import com.kms.katalon.composer.ai.studioassist.dialog.StudioAssistChatAttachmentFilter;
import com.kms.katalon.composer.ai.util.AttachmentUtil;
import com.kms.katalon.composer.components.impl.dialogs.TreeEntitySelectionDialog;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.EntityLabelProvider;
import com.kms.katalon.composer.components.impl.providers.EntityProvider;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.IncludeTreeRootEntity;
import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.impl.tree.ProfileRootTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestListenerFolderTreeEntity;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectFileSelectionDialog
extends TreeEntitySelectionDialog {
    private final Logger logger = LoggerFactory.getLogger(ProjectFileSelectionDialog.class);
    private List<ITreeEntity> checkedItems = new ArrayList<ITreeEntity>();

    public ProjectFileSelectionDialog(Shell parent) {
        super(parent, (IEntityLabelProvider)new EntityLabelProvider(), (ITreeContentProvider)new EntityProvider(), (AbstractEntityViewerFilter)new StudioAssistChatAttachmentFilter());
        this.setTitle("Select files to attach");
        this.setAllowMultiple(false);
        this.setDoubleClickSelects(false);
        try {
            this.setInput(this.getEntitiesToAttachFromProject());
        }
        catch (Exception e) {
            this.logger.error("Error while loading entities for ProjectFileSelectionDialog. ", (Throwable)e);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Attach", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public TreeViewer createTreeViewer(Composite parent) {
        final ContainerCheckedTreeViewer treeViewer = (ContainerCheckedTreeViewer)super.createTreeViewer(parent);
        treeViewer.getTree().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    TreeItem item = (TreeItem)event.item;
                    treeViewer.getTree().setSelection(item);
                    ProjectFileSelectionDialog.this.onStageChangedTreeItem(item.getData(), item.getChecked());
                }
            }
        });
        return treeViewer;
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        return new ContainerCheckedTreeViewer(new Tree(parent, 0x20 | style));
    }

    public List<ITreeEntity> getSelectedItems() {
        return this.checkedItems;
    }

    private List<ITreeEntity> getEntitiesToAttachFromProject() throws Exception {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        ArrayList<ITreeEntity> treeEntities = new ArrayList<ITreeEntity>();
        if (currentProject == null) {
            return treeEntities;
        }
        FolderController folderController = FolderController.getInstance();
        treeEntities.add((ITreeEntity)new ProfileRootTreeEntity(folderController.getProfileRoot(currentProject), null));
        treeEntities.add((ITreeEntity)new FolderTreeEntity(folderController.getTestCaseRoot(currentProject), null));
        treeEntities.add((ITreeEntity)new FolderTreeEntity(folderController.getTestSuiteRoot(currentProject), null));
        treeEntities.add((ITreeEntity)new FolderTreeEntity(folderController.getObjectRepositoryRoot(currentProject), null));
        treeEntities.add((ITreeEntity)new FolderTreeEntity(folderController.getKeywordRoot(currentProject), null));
        treeEntities.add((ITreeEntity)new TestListenerFolderTreeEntity(folderController.getTestListenerRoot(currentProject), null));
        treeEntities.add((ITreeEntity)new IncludeTreeRootEntity(folderController.getIncludeRoot(currentProject)));
        return treeEntities;
    }

    private void onStageChangedTreeItem(Object element, boolean isChecked) {
        try {
            if (element instanceof FolderTreeEntity) {
                FolderTreeEntity folderTreeEntity = (FolderTreeEntity)element;
                Object[] objectArray = folderTreeEntity.getChildren();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object childElement = objectArray[n2];
                    this.onStageChangedTreeItem(childElement, isChecked);
                    ++n2;
                }
            } else if (element instanceof PackageTreeEntity) {
                PackageTreeEntity packageTree = (PackageTreeEntity)element;
                Object[] objectArray = packageTree.getChildren();
                int n = objectArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Object childElement = objectArray[n3];
                    this.onStageChangedTreeItem(childElement, isChecked);
                    ++n3;
                }
            } else if (element instanceof ITreeEntity) {
                ITreeEntity entity = (ITreeEntity)element;
                if (isChecked) {
                    if (!this.haveChecked(entity) && AttachmentUtil.isSupportedAttachmentAsTreeEntity(entity, this.logger)) {
                        this.checkedItems.add(entity);
                    }
                } else {
                    this.checkedItems.remove(entity);
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private boolean haveChecked(ITreeEntity entity) {
        return this.checkedItems.stream().filter(each -> {
            try {
                return each.getText().equals(entity.getText());
            }
            catch (Exception e) {
                this.logger.warn("Something went wrong while checking checked items.", (Throwable)e);
                return false;
            }
        }).findFirst().isPresent();
    }
}

