/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.handlers;

import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import jakarta.inject.Inject;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOpenStudioAssistChatHandler {
    private final Logger logger = LoggerFactory.getLogger(BaseOpenStudioAssistChatHandler.class);
    @Inject
    private EModelService modelService;
    @Inject
    private EPartService partService;
    @Inject
    private MApplication application;
    @Inject
    private IFeatureController featureController;
    @Inject
    private IProductFeatureDialog productFeatureDialog;

    protected void openStudioAssistChatWindow() {
        if (!this.featureController.canUse(ProductFeature.STUDIOASSIST_EXECUTE_PROMPT)) {
            UISynchronizeService.syncExec(() -> this.productFeatureDialog.showNotAvailableFeature(ProductFeature.STUDIOASSIST_EXECUTE_PROMPT));
            return;
        }
        MPart part = (MPart)this.modelService.find("com.kms.katalon.composer.ai.studioassist.view", (MUIElement)this.application);
        if (part != null) {
            this.partService.showPart(part, EPartService.PartState.ACTIVATE);
            this.partService.bringToTop(part);
        } else {
            this.logger.warn("Part with ID {} not found", (Object)"com.kms.katalon.composer.ai.studioassist.view");
        }
    }
}

