/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.handlers;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.composer.ai.studioassist.handlers.BaseOpenStudioAssistChatHandler;
import com.kms.katalon.composer.constant.StudioAssistChatOpenOperationEnum;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenStudioAssistChatHandler
extends BaseOpenStudioAssistChatHandler {
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    public void postConstruct(MApplication application, EModelService modelService) {
        this.registerEvent();
    }

    private void registerEvent() {
        this.eventBroker.subscribe("PROJECT/LOAD_CLASS", new EventHandler(){

            public void handleEvent(Event event) {
                UserProfile currentUserProfile = UserProfileHelper.getCurrentProfile();
                if (StringUtils.isBlank((CharSequence)currentUserProfile.getEmail())) {
                    return;
                }
                if (!currentUserProfile.isStudioAssistChatFirstOpened()) {
                    currentUserProfile.setStudioAssistChatFirstOpened(true);
                    UserProfileHelper.saveProfile((UserProfile)currentUserProfile);
                    OpenStudioAssistChatHandler.this.openStudioAssistChatWindow();
                    OpenStudioAssistChatHandler.this.eventBroker.post("ON_TRACKING_OPEN_CHAT_WINDOW", (Object)StudioAssistChatOpenOperationEnum.AUTO);
                }
            }
        });
        this.eventBroker.subscribe("STUDIOASSIST/OPEN_CHAT", new EventHandler(){

            public void handleEvent(Event event) {
                OpenStudioAssistChatHandler.this.openStudioAssistChatWindow();
                OpenStudioAssistChatHandler.this.eventBroker.post("ON_TRACKING_OPEN_CHAT_WINDOW", (Object)StudioAssistChatOpenOperationEnum.START_PAGE);
            }
        });
    }

    @Execute
    public void execute() {
        this.openStudioAssistChatWindow();
        this.eventBroker.post("ON_TRACKING_OPEN_CHAT_WINDOW", (Object)StudioAssistChatOpenOperationEnum.GUI);
    }
}

