/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.preference;

import com.kms.katalon.ai.core.model.config.AzureOpenAIConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfigType;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.composer.ai.studioassist.preference.StudioAssistConfigComponent;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.session.core.model.AiConfigPolicy;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class AzureOpenAIConfigComponent
extends StudioAssistConfigComponent {
    private Text azureOpenAIBaseUrl;
    private Text azureOpenAIDeploymentName;
    private Text azureOpenAIAPIKey;
    private Text azureOpenAIMaxToken;
    private Text azureOpenAIAPIVersion;
    private final String BASE_URL = "Base URL";
    private final String DEPLOYMENT_NAME = "Deployment name";
    private final String API_KEY = "API key";
    private final String MAX_TOKEN = "Max completion token";
    private final String API_VERSION = "API version";

    public AzureOpenAIConfigComponent(Composite parent, AiConfigPolicy aiConfigPolicy) {
        super(parent, aiConfigPolicy);
    }

    @Override
    protected Composite createContent(Composite parent) {
        Composite outerComponent = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)1, (int)0).fillHorizontal().build();
        Composite component = (Composite)ComponentBuilder.group((Composite)outerComponent).gridLayout(2).fillHorizontal().build();
        ComponentBuilder.label((Composite)component).text("Base URL*").build();
        this.azureOpenAIBaseUrl = (Text)ComponentBuilder.text((Composite)component).fill().onChange(event -> {
            boolean bl = this.validateNotBlank("Base URL", this.azureOpenAIBaseUrl.getText(), true);
        }).build();
        ComponentBuilder.label((Composite)component).text("Deployment name*").build();
        this.azureOpenAIDeploymentName = (Text)ComponentBuilder.text((Composite)component).fill().onChange(event -> {
            boolean bl = this.validateNotBlank("Deployment name", this.azureOpenAIDeploymentName.getText(), true);
        }).build();
        ComponentBuilder.label((Composite)component).text("API key*").build();
        this.azureOpenAIAPIKey = (Text)ComponentBuilder.text((Composite)component).maskPassword().fill().onChange(event -> {
            boolean bl = this.validateNotBlank("API key", this.azureOpenAIAPIKey.getText(), true);
        }).build();
        ComponentBuilder.label((Composite)component).text("Max completion token*").build();
        this.azureOpenAIMaxToken = (Text)ComponentBuilder.text((Composite)component).fill().onChange(event -> this.validateMaxToken("Max completion token", this.azureOpenAIMaxToken.getText(), true)).build();
        ComponentBuilder.label((Composite)component).text("API version*").build();
        this.azureOpenAIAPIVersion = (Text)ComponentBuilder.text((Composite)component).placeholder("2024-02-01").fill().onChange(event -> {
            boolean bl = this.validateNotBlank("API version", this.azureOpenAIAPIVersion.getText(), true);
        }).build();
        this.content = outerComponent;
        return outerComponent;
    }

    @Override
    protected void onSwitchOption(StudioAssistConfigType type) {
        boolean hasChosenAzureOpenAI = type == StudioAssistConfigType.AZURE_OPENAI;
        this.displayContent(hasChosenAzureOpenAI);
        if (hasChosenAzureOpenAI) {
            this.resetMessage(hasChosenAzureOpenAI);
        }
    }

    @Override
    protected void loadConfig() throws StudioAssistLoadingConfigException {
        StudioAssistConfig config = this.controller.getConfig();
        boolean usingAzureOpenAI = config instanceof AzureOpenAIConfig;
        if (usingAzureOpenAI) {
            AzureOpenAIConfig azureOpenAIConfig = (AzureOpenAIConfig)config;
            this.azureOpenAIBaseUrl.setText(azureOpenAIConfig.getBaseUrl());
            this.azureOpenAIAPIKey.setText(azureOpenAIConfig.getApiKey());
            this.azureOpenAIMaxToken.setText(Long.toString(azureOpenAIConfig.getMaxToken()));
            this.azureOpenAIDeploymentName.setText(azureOpenAIConfig.getDeploymentName());
            if (StringUtils.isBlank((CharSequence)azureOpenAIConfig.getApiVersion())) {
                this.azureOpenAIAPIVersion.setText("2024-02-01");
            } else {
                this.azureOpenAIAPIVersion.setText(azureOpenAIConfig.getApiVersion());
            }
        } else {
            this.azureOpenAIMaxToken.setText(Integer.toString(16000));
        }
        this.displayContent(usingAzureOpenAI);
    }

    @Override
    public void saveConfig() throws StudioAssistSavingConfigException {
        AzureOpenAIConfig azureOpenAIConfig = new AzureOpenAIConfig();
        azureOpenAIConfig.setApiKey(this.azureOpenAIAPIKey.getText());
        azureOpenAIConfig.setBaseUrl(this.azureOpenAIBaseUrl.getText());
        azureOpenAIConfig.setDeploymentName(this.azureOpenAIDeploymentName.getText());
        azureOpenAIConfig.setMaxToken(Integer.valueOf(this.azureOpenAIMaxToken.getText()).intValue());
        azureOpenAIConfig.setApiVersion(this.azureOpenAIAPIVersion.getText());
        this.controller.saveConfig((StudioAssistConfig)azureOpenAIConfig);
    }

    @Override
    public void resetConfig() {
        this.azureOpenAIBaseUrl.setText("");
        this.azureOpenAIAPIKey.setText("");
        this.azureOpenAIMaxToken.setText("");
        this.azureOpenAIDeploymentName.setText("");
        this.azureOpenAIAPIVersion.setText("");
        this.displayContent(false);
    }

    @Override
    protected void initValidationList() {
        this.validationList.put("Base URL", false);
        this.validationList.put("Deployment name", false);
        this.validationList.put("API key", false);
        this.validationList.put("Max completion token", false);
        this.validationList.put("API version", false);
    }
}

