/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.preference;

import com.kms.katalon.ai.core.model.config.OpenAiCompatibleConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfigType;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.composer.ai.studioassist.preference.StudioAssistConfigComponent;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.session.core.model.AiConfigPolicy;
import com.kms.katalon.session.core.model.ManagedOpenAiCompatibleConfig;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ManagedOpenAiCompatiblePage
extends StudioAssistConfigComponent {
    private Text openAiCompatibleModel;
    private Text openAiCompatibleMaxToken;
    private final String BASE_URL = "Base URL";
    private final String API_KEY = "API key";
    private final String API_KEY_HEADER_NAME = "API key header name";
    private final String MODEL = "Model";
    private final String MAX_TOKEN = "Max completion token";

    public ManagedOpenAiCompatiblePage(Composite parent, AiConfigPolicy aiConfigPolicy) {
        super(parent, aiConfigPolicy);
    }

    @Override
    protected Composite createContent(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2, (int)0).build();
        ComponentBuilder.label((Composite)container).text("OpenAI-compatible provider").bold().build();
        ComponentBuilder.label((Composite)container).text("- managed by your organization").build();
        Composite component = (Composite)ComponentBuilder.group((Composite)parent).gridLayout(2).fillHorizontal().build();
        ComponentBuilder.label((Composite)component).text("Base URL*").build();
        ComponentBuilder.text((Composite)component).text(((ManagedOpenAiCompatibleConfig)this.aiConfigPolicy.getManagedOpenAiCompatible().get()).getBaseUrl()).fill().disable().build();
        ComponentBuilder.label((Composite)component).text("API key").build();
        ComponentBuilder.text((Composite)component).text(((ManagedOpenAiCompatibleConfig)this.aiConfigPolicy.getManagedOpenAiCompatible().get()).getApiKey()).maskPassword().disable().fill().build();
        ComponentBuilder.label((Composite)component).text("API key header name").build();
        ComponentBuilder.text((Composite)component).text(((ManagedOpenAiCompatibleConfig)this.aiConfigPolicy.getManagedOpenAiCompatible().get()).getApiKeyHeaderName()).fill().disable().build();
        ComponentBuilder.label((Composite)component).text("Model").build();
        this.openAiCompatibleModel = (Text)ComponentBuilder.text((Composite)component).placeholder("gpt-4.1-mini").fill().build();
        ComponentBuilder.label((Composite)component).text("Max completion token*").build();
        this.openAiCompatibleMaxToken = (Text)ComponentBuilder.text((Composite)component).fill().onChange(event -> this.validateMaxToken("Max completion token", this.openAiCompatibleMaxToken.getText(), true)).build();
        return component;
    }

    @Override
    protected void onSwitchOption(StudioAssistConfigType type) {
        boolean hasChosenOpenAiCompatible = type == StudioAssistConfigType.OPENAI_COMPATIBLE;
        this.displayContent(hasChosenOpenAiCompatible);
        if (hasChosenOpenAiCompatible) {
            this.resetMessage(hasChosenOpenAiCompatible);
        }
    }

    @Override
    protected void loadConfig() throws StudioAssistLoadingConfigException {
        StudioAssistConfig config = this.controller.getConfig();
        boolean usingOpenAiCompatible = config instanceof OpenAiCompatibleConfig;
        if (usingOpenAiCompatible) {
            OpenAiCompatibleConfig openAiCompatibleConfig = (OpenAiCompatibleConfig)config;
            String model = (String)StringUtils.defaultIfBlank((CharSequence)openAiCompatibleConfig.getModelName(), (CharSequence)"gpt-4.1-mini");
            this.openAiCompatibleModel.setText(model);
            this.openAiCompatibleMaxToken.setText(Long.toString(openAiCompatibleConfig.getMaxToken()));
        } else {
            this.openAiCompatibleModel.setText("gpt-4.1-mini");
            this.openAiCompatibleMaxToken.setText(Integer.toString(16000));
        }
        this.displayContent(usingOpenAiCompatible);
    }

    @Override
    public void saveConfig() throws StudioAssistSavingConfigException {
        OpenAiCompatibleConfig openAiCompatibleConfig = new OpenAiCompatibleConfig();
        openAiCompatibleConfig.setModelName(this.openAiCompatibleModel.getText());
        openAiCompatibleConfig.setMaxToken(Integer.valueOf(this.openAiCompatibleMaxToken.getText()).intValue());
        this.controller.saveConfig((StudioAssistConfig)openAiCompatibleConfig);
    }

    @Override
    public void resetConfig() {
        this.openAiCompatibleModel.setText("gpt-4.1-mini");
        this.openAiCompatibleMaxToken.setText(String.valueOf(16000));
        this.displayContent(false);
    }

    @Override
    protected void initValidationList() {
        this.validationList.put("Max completion token", false);
    }
}

