/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.preference;

import com.kms.katalon.ai.core.model.config.StudioAssistConfigType;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.ai.core.services.IStudioAssistController;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.LoginMethod;
import com.kms.katalon.composer.ai.studioassist.preference.StudioAssistPreferencePage;
import com.kms.katalon.session.core.model.AiConfigPolicy;
import com.kms.katalon.session.core.model.AiConfigPolicyType;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public abstract class StudioAssistConfigComponent {
    @Inject
    protected IStudioAssistController controller;
    @Inject
    protected IFeatureController featureController;
    @Inject
    protected IProductFeatureDialog productFeatureDialog;
    protected Composite parent;
    protected Composite content;
    protected AiConfigPolicy aiConfigPolicy;
    protected StudioAssistConfigComponent[] siblings;
    protected StudioAssistPreferencePage mainPreferencePage;
    protected Map<String, Boolean> validationList = new HashMap<String, Boolean>();

    public StudioAssistConfigComponent(Composite parent, AiConfigPolicy aiConfigPolicy) {
        this.aiConfigPolicy = aiConfigPolicy;
        this.parent = parent;
    }

    @PostConstruct
    public void postConstruct() {
        this.content = this.createContent(this.parent);
        this.initValidationList();
    }

    public void setSiblings(StudioAssistConfigComponent[] siblings) {
        this.siblings = siblings;
    }

    public void setMainPreferencePage(StudioAssistPreferencePage studioAssistPreferencePage) {
        this.mainPreferencePage = studioAssistPreferencePage;
    }

    public void displayContent(final boolean isDisplay) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                StudioAssistConfigComponent.this.content.setVisible(isDisplay);
                GridData gdBodyComposite = (GridData)StudioAssistConfigComponent.this.content.getLayoutData();
                gdBodyComposite.exclude = !isDisplay;
                Composite parent = StudioAssistConfigComponent.this.content.getParent();
                parent.pack();
            }
        });
    }

    protected boolean validateNotBlank(String fieldName, String input, boolean shouldDisplayError) {
        if (StringUtils.isBlank((CharSequence)input)) {
            this.validationList.replace(fieldName, false);
            if (shouldDisplayError) {
                this.displayErrorMessage(MessageFormat.format("{0} cannot be null.", fieldName));
            } else {
                this.mainPreferencePage.setValid(false);
                this.mainPreferencePage.setErrorMessage(null);
            }
            return false;
        }
        this.validationList.replace(fieldName, true);
        this.mainPreferencePage.setErrorMessage(null);
        this.resetMessage(true);
        return true;
    }

    protected void validateMaxToken(String fieldName, String input, boolean shouldDisplayError) {
        if (StringUtils.isBlank((CharSequence)input)) {
            this.validationList.replace(fieldName, false);
            if (shouldDisplayError) {
                this.displayErrorMessage("Max completion token cannot be null.");
            } else {
                this.mainPreferencePage.setValid(false);
                this.mainPreferencePage.setErrorMessage(null);
            }
            return;
        }
        boolean isValidInput = true;
        try {
            int value = Integer.parseInt(input);
            isValidInput = value > 0;
        }
        catch (Exception exception) {
            isValidInput = false;
        }
        if (!isValidInput) {
            this.validationList.replace(fieldName, false);
            this.displayErrorMessage("Max completion token must be a positive Integer.");
        } else {
            this.validationList.replace(fieldName, true);
            this.resetMessage(true);
        }
    }

    protected void displayErrorMessage(String message) {
        this.mainPreferencePage.setValid(false);
        this.mainPreferencePage.setErrorMessage(message);
    }

    protected void resetMessage(boolean selected) {
        if (selected) {
            boolean isValid = !this.validationList.containsValue(false);
            this.mainPreferencePage.setValid(isValid);
        }
        this.mainPreferencePage.setErrorMessage(null);
    }

    protected abstract Composite createContent(Composite var1);

    protected abstract void onSwitchOption(StudioAssistConfigType var1);

    protected abstract void loadConfig() throws StudioAssistLoadingConfigException;

    public abstract void saveConfig() throws StudioAssistSavingConfigException;

    public abstract void resetConfig();

    protected abstract void initValidationList();

    protected boolean isKatalonAIAvailable() {
        boolean isAIDisabled;
        boolean isOnPrem = !ApplicationInfo.getLoginMethod().equals((Object)LoginMethod.SSO);
        boolean bl = isAIDisabled = this.aiConfigPolicy.getAiConfigPolicyType() == AiConfigPolicyType.AI_DISABLED;
        return !isOnPrem && !isAIDisabled;
    }
}

