/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.selenium.ide.util;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.selenium.ide.model.TestCase;
import com.kms.katalon.selenium.ide.model.TestSuite;
import com.kms.katalon.selenium.ide.util.FileUtils;
import com.kms.katalon.selenium.ide.util.ParsedResult;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class JsonParser {
    public static ParsedResult parse(File file) {
        String projectJsonContent = FileUtils.readFileToString(file.toPath());
        JsonObject convertedProject = (JsonObject)JsonUtil.fromJson((String)projectJsonContent, JsonObject.class);
        Type testCaseListType = new TypeToken<ArrayList<TestCase>>(){}.getType();
        List testCases = (List)JsonUtil.fromJson((String)convertedProject.get("tests").toString(), (Type)testCaseListType);
        String baseUrl = convertedProject.get("url").getAsString();
        Type testSuiteListType = new TypeToken<ArrayList<TestSuite>>(){}.getType();
        List testSuites = (List)JsonUtil.fromJson((String)convertedProject.get("suites").toString(), (Type)testSuiteListType);
        HashMap<String, String> monoSuiteTests = new HashMap<String, String>();
        testSuites.forEach(ts -> {
            ts.setName(JsonParser.toValidFileName(ts.getName()));
            ts.getTests().forEach(id -> {
                if (!monoSuiteTests.containsKey(id)) {
                    monoSuiteTests.put((String)id, ts.getName());
                } else if (monoSuiteTests.get(id) != null) {
                    monoSuiteTests.put((String)id, (String)null);
                }
            });
        });
        testCases.forEach(tc -> {
            tc.setBaseUrl(baseUrl);
            tc.setName(JsonParser.toValidFileName(tc.getName()));
            tc.setFilePath(file.getAbsolutePath());
        });
        return new ParsedResult(testSuites, testCases, monoSuiteTests);
    }

    private static String toValidFileName(String fileName) {
        return fileName.trim().replaceAll("[^A-Za-z-0-9_().\\- ]", "");
    }
}

