/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.middle;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class KatalonMiddleApp {
    private static final String KATALON_APP_NAME = "\\katalon.exe";
    private static final String KATALON_MIDDLE_APP_LOCATION = "\\configuration\\resources\\middle\\KatalonApp.exe";
    private static final Logger logger = Logger.getLogger(KatalonMiddleApp.class.getName());

    public static void main(String[] args) throws SecurityException, IOException {
        String actionType;
        FileHandler fileHandler = new FileHandler("KatalonApp.log", true);
        fileHandler.setFormatter(new SimpleFormatter());
        logger.addHandler(fileHandler);
        if (args.length <= 0) {
            logger.warning("Invalid args");
            return;
        }
        switch (actionType = args[0].toUpperCase()) {
            case "OPEN": {
                KatalonMiddleApp.openKatalonStudioApp();
                break;
            }
            case "UPDATE": {
                if (args.length <= 1) {
                    logger.warning("Invalid args for UPDATE action");
                    break;
                }
                String exePackageRootPath = args[1];
                KatalonMiddleApp.updateRegistry(exePackageRootPath);
                break;
            }
            default: {
                logger.warning("Only process for OPEN or UPDATE action");
            }
        }
    }

    public static void updateRegistry(String exePackageRootPath) {
        try {
            String protocol;
            String keyPath = protocol = "katalonstudio";
            if (!Advapi32Util.registryKeyExists(WinReg.HKEY_CLASSES_ROOT, keyPath)) {
                Advapi32Util.registryCreateKey(WinReg.HKEY_CLASSES_ROOT, keyPath);
                System.out.println("Registry key created: " + keyPath);
                logger.info("Registry key created: " + keyPath);
            } else {
                logger.info("Registry key already exists: " + keyPath);
            }
            Advapi32Util.registrySetStringValue(WinReg.HKEY_CLASSES_ROOT, keyPath, "", "Katalon Studio App");
            logger.info("Default value set: Katalon Studio App");
            Advapi32Util.registrySetStringValue(WinReg.HKEY_CLASSES_ROOT, keyPath, "URL Protocol", "");
            logger.info("URL Protocol value set");
            Advapi32Util.registrySetStringValue(WinReg.HKEY_CLASSES_ROOT, keyPath, "FriendlyTypeName", "Open in Katalon Studio");
            logger.info("Friendly Type Name value set");
            Advapi32Util.registrySetStringValue(WinReg.HKEY_CLASSES_ROOT, keyPath, "ExePackageRootPath", exePackageRootPath);
            logger.info("Exe Package Root Path value set");
            String commandKeyPath = keyPath + "\\shell\\open\\command";
            if (!Advapi32Util.registryKeyExists(WinReg.HKEY_CLASSES_ROOT, commandKeyPath)) {
                Advapi32Util.registryCreateKey(WinReg.HKEY_CLASSES_ROOT, commandKeyPath);
                logger.info("Registry subkey created: " + commandKeyPath);
            }
            String exePath = exePackageRootPath + KATALON_MIDDLE_APP_LOCATION;
            String commandValue = "\"" + exePath + "\" \"OPEN\"";
            Advapi32Util.registrySetStringValue(WinReg.HKEY_CLASSES_ROOT, commandKeyPath, "", commandValue);
            logger.info("Command value set: " + commandValue);
            logger.info("Update Registry successfully");
        }
        catch (Exception ex) {
            logger.severe("Failed to update Windows Registry: " + String.valueOf(ex));
        }
    }

    private static void openKatalonStudioApp() {
        try {
            String keyPath = "katalonstudio";
            String valueName = "ExePackageRootPath";
            String exePackageRootPath = KatalonMiddleApp.readRegistry(keyPath, valueName);
            if (exePackageRootPath.isBlank()) {
                logger.warning("ExePackagePath value not found, cannot open Katalon Studio app");
                return;
            }
            String exePath = exePackageRootPath + KATALON_APP_NAME;
            logger.info("Open katalon.exe in path: " + exePath);
            new ProcessBuilder(exePath).start();
            logger.info("Open Katalon Studio App successfully");
        }
        catch (Exception ex) {
            logger.severe("Failed to open Katalon Studio app: " + String.valueOf(ex));
        }
    }

    private static String readRegistry(String keyPath, String valueName) {
        try {
            if (Advapi32Util.registryKeyExists(WinReg.HKEY_CLASSES_ROOT, keyPath)) {
                String value = Advapi32Util.registryGetStringValue(WinReg.HKEY_CLASSES_ROOT, keyPath, valueName);
                return value != null ? new String(value).trim() : null;
            }
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

