/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions;

import java.util.List;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.IValueCheckingRule;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.MethodParameter;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ValueStatus;

public class DuplicateParameterRule
implements IValueCheckingRule {
    private List<MethodParameter> existingParameters;
    static final String ERROR = "Parameter with the same name already exists. Choose a distinct parameter name.";

    public DuplicateParameterRule(List<MethodParameter> existingParameters) {
        this.existingParameters = existingParameters;
    }

    @Override
    public ValueStatus checkValidity(Object value) {
        if (!(value instanceof String) || this.existingParameters == null) {
            return ValueStatus.getErrorStatus(value);
        }
        String paramName = (String)value;
        ValueStatus status = ValueStatus.getValidStatus(value);
        for (MethodParameter existingParamter : this.existingParameters) {
            if (!existingParamter.getName().equals(paramName)) continue;
            status = ValueStatus.getErrorStatus(value, ERROR);
            break;
        }
        return status;
    }
}

