/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions;

import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.AbstractCreateOperation;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.AddSuggestionsOperation;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.EditSuggestionOperation;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.GroovySuggestionDeclaringType;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.IBaseGroovySuggestion;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.IGroovySuggestion;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.SuggestionDescriptor;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ValueStatus;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.AddInferencingSuggestionDialogue;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.EditInferencingSuggestionDialogue;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Shell;

public class SuggestionsUIOperation {
    private Shell shell;
    private AbstractCreateOperation operation;
    protected static final String UNABLE_TO_OPEN_DIALOGUE = "Unable to open suggestions dialogue";

    public SuggestionsUIOperation(AbstractCreateOperation operation, Shell shell) {
        this.shell = shell;
        this.operation = operation;
    }

    public ValueStatus run() {
        SuggestionDescriptor descriptor;
        IBaseGroovySuggestion context = this.operation.getContext();
        AddInferencingSuggestionDialogue dialogue = null;
        IProject project = this.operation.getProject();
        if (context == null) {
            descriptor = this.operation.getDescriptor();
            dialogue = descriptor != null ? new AddInferencingSuggestionDialogue(this.shell, descriptor, project) : new AddInferencingSuggestionDialogue(this.shell, project);
        } else if (context instanceof GroovySuggestionDeclaringType) {
            dialogue = new AddInferencingSuggestionDialogue(this.shell, (GroovySuggestionDeclaringType)context, project);
        } else if (context instanceof IGroovySuggestion) {
            if (this.operation instanceof EditSuggestionOperation) {
                dialogue = new EditInferencingSuggestionDialogue(this.shell, (IGroovySuggestion)context, project);
            } else if (this.operation instanceof AddSuggestionsOperation) {
                dialogue = new AddInferencingSuggestionDialogue(this.shell, ((IGroovySuggestion)context).getDeclaringType(), project);
            }
        }
        if (dialogue != null && dialogue.open() == 0) {
            descriptor = dialogue.getSuggestionChange();
            this.operation.setSuggestionDescriptor(descriptor);
            return this.operation.run();
        }
        return ValueStatus.getErrorStatus(null, UNABLE_TO_OPEN_DIALOGUE);
    }
}

