/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.preferencepage;

import java.util.List;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.InferencingSuggestionsManager;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.preferencepage.GroovySuggestionsTable;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class InferencingPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IWorkbenchPage page;
    private GroovySuggestionsTable table;
    public static final String PAGE_DESCRIPTION = "Select a project to manage the Groovy inferencing suggestions.";

    public InferencingPreferencesPage() {
        this.setDescription(PAGE_DESCRIPTION);
    }

    public void init(IWorkbench workbench) {
        if (workbench != null && workbench.getActiveWorkbenchWindow() != null) {
            this.page = workbench.getActiveWorkbenchWindow().getActivePage();
        }
    }

    protected IWorkbenchPage getPage() {
        return this.page;
    }

    protected Control createContents(Composite parent) {
        List projects = GroovyNature.getAllAccessibleGroovyProjects();
        this.table = new GroovySuggestionsTable(projects);
        return this.table.createTable(parent);
    }

    public boolean performOk() {
        if (super.performOk()) {
            IProject project = this.table.getSelectedProject();
            InferencingSuggestionsManager.getInstance().commitChanges(project);
            return true;
        }
        return false;
    }

    public boolean performCancel() {
        IProject project = this.table.getSelectedProject();
        InferencingSuggestionsManager.getInstance().restoreSuggestions(project);
        return super.performCancel();
    }
}

