/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.preferencepage;

import java.util.List;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.GroovyMethodSuggestion;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.MethodParameter;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.preferencepage.AbstractSuggestionLabel;

public class MethodSuggestionLabel
extends AbstractSuggestionLabel {
    private GroovyMethodSuggestion suggestion;

    public MethodSuggestionLabel(GroovyMethodSuggestion suggestion) {
        this.suggestion = suggestion;
    }

    @Override
    protected String constructName() {
        List<MethodParameter> parameters;
        if (this.suggestion == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        String name = this.suggestion.getName();
        buffer.append(name);
        String typeName = this.suggestion.getType();
        if (typeName != null && typeName.length() > 0) {
            buffer.append(" ");
            buffer.append(":");
            buffer.append(" ");
            buffer.append(typeName);
        }
        if ((parameters = this.suggestion.getParameters()) != null) {
            buffer.append("(");
            int size = parameters.size();
            for (MethodParameter param : parameters) {
                String paramType = param.getType();
                if (paramType != null && paramType.length() > 0) {
                    buffer.append(paramType);
                    buffer.append(" ");
                }
                buffer.append(param.getName());
                if (--size <= 0) continue;
                buffer.append(",");
                buffer.append(" ");
            }
            buffer.append(")");
        }
        return buffer.toString();
    }
}

