/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.lookup;

import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.jdt.groovy.search.VariableScope;

public class ResolverCache {
    private final Map<String, ClassNode> nameTypeCache = new WeakHashMap<String, ClassNode>();
    private final JDTResolver resolver;
    public final ModuleNode module;

    public ResolverCache(JDTResolver resolver, ModuleNode module) {
        this.resolver = resolver;
        this.module = module;
    }

    public ClassNode resolve(String name) {
        if (name == null || (name = name.trim()).isEmpty()) {
            return ClassHelper.dynamicType();
        }
        if ("void".equals(name) || "java.lang.Void".equals(name)) {
            return VariableScope.VOID_CLASS_NODE;
        }
        ClassNode type = this.nameTypeCache.get(name);
        if (type == null && this.resolver != null) {
            Object componentName;
            int typeParamEnd = name.lastIndexOf(62);
            int arrayStart = name.indexOf(91, typeParamEnd);
            int arrayCount = 0;
            if (arrayStart > 0) {
                componentName = name.substring(0, arrayStart);
                arrayCount = this.calculateArrayCount(name, arrayStart);
            } else {
                componentName = name;
            }
            String erasureName = componentName;
            int typeParamStart = -1;
            if (typeParamEnd > 0 && (typeParamStart = ((String)componentName).indexOf(60)) > 0) {
                erasureName = ((String)componentName).substring(0, typeParamStart);
            }
            if ((type = this.resolver.resolve(erasureName)) == null) {
                type = VariableScope.OBJECT_CLASS_NODE;
            }
            this.nameTypeCache.put(erasureName, type);
            if (typeParamStart > 0 && type.isUsingGenerics()) {
                String[] typeParameterNames = ((String)componentName).substring(typeParamStart + 1, ((String)componentName).length() - 1).split("\\s*,\\s*");
                ClassNode[] typeParameterTypes = new ClassNode[typeParameterNames.length];
                int i = 0;
                while (i < typeParameterNames.length) {
                    typeParameterTypes[i] = this.resolve(typeParameterNames[i].replaceFirst("^\\?\\s+(extends|super)\\s+", ""));
                    ++i;
                }
                type = VariableScope.clone((ClassNode)type);
                GenericsType[] genericsTypes = type.getGenericsTypes();
                int i2 = 0;
                while (i2 < genericsTypes.length && i2 < typeParameterTypes.length) {
                    if (typeParameterNames[i2].startsWith("?")) {
                        genericsTypes[i2] = GenericsUtils.buildWildcardType((ClassNode[])new ClassNode[]{typeParameterTypes[i2]});
                    } else {
                        genericsTypes[i2].setName(typeParameterTypes[i2].getName());
                        genericsTypes[i2].setType(typeParameterTypes[i2]);
                        genericsTypes[i2].setPlaceHolder(false);
                        genericsTypes[i2].setUpperBounds(null);
                        genericsTypes[i2].setLowerBound(null);
                        genericsTypes[i2].setWildcard(false);
                    }
                    genericsTypes[i2].setResolved(true);
                    ++i2;
                }
                this.nameTypeCache.put((String)componentName, type);
            }
            while (arrayCount > 0) {
                --arrayCount;
                componentName = (String)componentName + "[]";
                type = type.makeArray();
                this.nameTypeCache.put((String)componentName, type);
            }
        }
        return name.indexOf(60) < 0 ? GenericsUtils.nonGeneric((ClassNode)type) : type;
    }

    private int calculateArrayCount(String qName, int arrayStart) {
        if (arrayStart < 0) {
            return 0;
        }
        int cnt = 1;
        while ((arrayStart = qName.indexOf(91, arrayStart + 1)) > 0) {
            ++cnt;
        }
        return cnt;
    }
}

