/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.groovy.eclipse.dsl.contributions.DSLContributionGroup;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.groovy.eclipse.dsl.pointcuts.IPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.PointcutVerificationException;
import org.codehaus.groovy.eclipse.dsl.pointcuts.StringObjectVector;
import org.codehaus.groovy.eclipse.dsl.pointcuts.impl.AndPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.impl.NotPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.impl.OrPointcut;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;

public abstract class AbstractPointcut
implements IPointcut {
    private IStorage containerIdentifier;
    private StringObjectVector elements = new StringObjectVector(1);
    private String pointcutName;
    private IProject project;

    public AbstractPointcut(IStorage containerIdentifier, String pointcutName) {
        this.containerIdentifier = containerIdentifier;
        this.pointcutName = pointcutName;
    }

    @Override
    public String getPointcutDebugName() {
        return this.pointcutName + " (" + this.getClass().getSimpleName() + ")";
    }

    @Override
    public String getPointcutName() {
        return this.pointcutName;
    }

    public void setPointcutName(String pointcutName) {
        this.pointcutName = pointcutName;
    }

    @Override
    public IStorage getContainerIdentifier() {
        return this.containerIdentifier;
    }

    public void setContainerIdentifier(IStorage containerIdentifier) {
        this.containerIdentifier = containerIdentifier;
    }

    @Override
    public final void addArgument(Object argument) {
        this.elements.add(null, argument);
    }

    @Override
    public final void addArgument(String name, Object argument) {
        if (name == null) {
            this.addArgument(argument);
            return;
        }
        this.elements.add(name, argument);
    }

    @Override
    public void verify() throws PointcutVerificationException {
        if (this.elements.size > 1) {
            throw new PointcutVerificationException("Can't have more than one argument to this pointcut", this);
        }
    }

    @Override
    public abstract Collection<?> matches(GroovyDSLDContext var1, Object var2);

    protected Collection<?> matchOnPointcutArgument(IPointcut argument, GroovyDSLDContext pattern, Collection<?> elementsToMatch) {
        if (elementsToMatch != null) {
            ArrayList outer = new ArrayList();
            for (Object toMatch : elementsToMatch) {
                Collection<?> inner = argument.matches(pattern, toMatch);
                if (inner == null || inner.isEmpty()) continue;
                this.addToBinding(argument, pattern, inner);
                outer.add(toMatch);
            }
            if (!outer.isEmpty()) {
                return outer;
            }
        }
        return null;
    }

    protected Collection<?> matchOnPointcutArgumentReturnInner(IPointcut argument, GroovyDSLDContext pattern, Collection<?> elementsToMatch) {
        if (elementsToMatch != null) {
            ArrayList outer = new ArrayList();
            for (Object toMatch : elementsToMatch) {
                Collection<?> inner = argument.matches(pattern, toMatch);
                if (inner == null || inner.isEmpty()) continue;
                outer.addAll(inner);
            }
            if (!outer.isEmpty()) {
                this.addToBinding(argument, pattern, outer);
                return outer;
            }
        }
        return null;
    }

    private void addToBinding(IPointcut argument, GroovyDSLDContext pattern, Collection<?> values) {
        String bindingName = this.getArgumentName(argument);
        if (bindingName != null) {
            pattern.addToBinding(bindingName, values);
        }
    }

    protected Collection<?> flatten(Map<Object, Collection<?>> pointcutResult) {
        ArrayList outer = new ArrayList(pointcutResult.size());
        for (Collection<?> inner : pointcutResult.values()) {
            outer.addAll(inner);
        }
        return outer;
    }

    @Override
    public final Object getFirstArgument() {
        if (this.elements.size > 0) {
            return this.elements.elementAt(0);
        }
        return null;
    }

    @Override
    public final String[] getArgumentNames() {
        return this.elements.getNames();
    }

    @Override
    public final Object[] getArgumentValues() {
        return this.elements.getElements();
    }

    public final String getArgumentName(Object argument) {
        int i = 0;
        while (i < this.elements.size) {
            if (this.elements.elementAt(i) == argument) {
                return this.elements.nameAt(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public final String getFirstArgumentName() {
        if (this.elements.size > 0) {
            return this.elements.nameAt(0);
        }
        return null;
    }

    public final String getNameForArgument(Object arg) {
        return this.elements.nameOf(arg);
    }

    @Override
    public IPointcut normalize() {
        int i = 0;
        int n = this.elements.size;
        while (i < n) {
            Object elt = this.elements.elementAt(i);
            if (elt instanceof IPointcut) {
                this.elements.setElement(((IPointcut)elt).normalize(), i);
            }
            ++i;
        }
        return this;
    }

    @Override
    public boolean fastMatch(GroovyDSLDContext pattern) {
        Object[] objectArray = this.elements.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object elt = objectArray[n2];
            if (elt instanceof IPointcut && !((IPointcut)elt).fastMatch(pattern)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void setProject(IProject project) {
        this.project = project;
    }

    @Override
    public void accept(Closure contributionGroupClosure) {
        block4: {
            DSLContributionGroup group = new DSLContributionGroup(contributionGroupClosure);
            if (this.project != null) {
                try {
                    this.verify();
                    IProject p = this.project;
                    IPointcut normalized = this.normalize();
                    if (GroovyLogManager.manager.hasLoggers()) {
                        GroovyLogManager.manager.log(TraceCategory.DSL, "Registering pointcut:\n" + this.toString());
                    }
                    GroovyDSLCoreActivator.getDefault().getContextStoreManager().getDSLDStore(p).addContributionGroup(normalized, group);
                }
                catch (PointcutVerificationException e) {
                    if (!GroovyLogManager.manager.hasLoggers()) break block4;
                    GroovyLogManager.manager.log(TraceCategory.DSL, "Ignoring invalid pointcut");
                    GroovyLogManager.manager.log(TraceCategory.DSL, e.getPointcutMessage());
                    GroovyLogManager.manager.logException(TraceCategory.DSL, (Throwable)e);
                }
            }
        }
    }

    protected final String allArgsArePointcuts() throws PointcutVerificationException {
        Object[] objectArray = this.elements.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            if (arg instanceof IPointcut) {
                ((IPointcut)arg).verify();
            } else if (arg != null) {
                return "All arguments should be pointcuts";
            }
            ++n2;
        }
        return null;
    }

    protected final String allArgsAreClasses() {
        Object[] objectArray = this.elements.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            if (arg != null && !(arg instanceof Class)) {
                return "All arguments should be classes";
            }
            ++n2;
        }
        return null;
    }

    protected final String allArgsAreStrings() {
        Object[] objectArray = this.elements.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            if (arg != null && !(arg instanceof String)) {
                return "All arguments should be strings";
            }
            ++n2;
        }
        return null;
    }

    protected final String matchesArgNumber(int num) {
        Object[] elements2 = this.elements.getElements();
        if (elements2.length == num) {
            return null;
        }
        return "Expecting " + num + " arguments, but found " + elements2.length;
    }

    protected final String hasOneArg() {
        if (this.elements.getElements().length == 1) {
            return null;
        }
        return "Expecting 1 argument, but found " + this.elements.getElements().length + ".  Consider using '&' or '|' to connect arguments.";
    }

    protected final String hasOneOrNoArgs() {
        if (this.elements.getElements().length <= 1) {
            return null;
        }
        return "Expecting 1 or no arguments, but found " + this.elements.getElements().length + ".  Consider using '&' or '|' to connect arguments.";
    }

    protected final String hasNoArgs() {
        if (this.elements.getElements().length == 0) {
            return null;
        }
        return "Expecting no arguments, but found " + this.elements.getElements().length + ".  Consider using '&' or '|' to connect arguments.";
    }

    protected final String oneStringOrOnePointcutArg() throws PointcutVerificationException {
        if (this.allArgsArePointcuts() != null && this.allArgsAreStrings() != null) {
            return "This pointcut supports exactly one argument of type Pointcut or String.  Consider using '&' or '|' to connect arguments.";
        }
        String message = this.hasOneArg();
        return message != null ? message : null;
    }

    protected final String oneStringOrOnePointcutOrOneClassArg() throws PointcutVerificationException {
        if (this.allArgsArePointcuts() != null && this.allArgsAreStrings() != null && this.allArgsAreClasses() != null) {
            return "This pointcut supports exactly one argument of type Pointcut or String or Class.  Consider using '&' or '|' to connect arguments.";
        }
        String message = this.hasOneArg();
        return message != null ? message : null;
    }

    protected IPointcut and(IPointcut other) {
        AndPointcut andPointcut = new AndPointcut(this.containerIdentifier, "and");
        andPointcut.addArgument(this);
        andPointcut.addArgument(other);
        andPointcut.setProject(this.project);
        return andPointcut;
    }

    protected IPointcut or(IPointcut other) {
        OrPointcut orPointcut = new OrPointcut(this.containerIdentifier, "or");
        orPointcut.addArgument(this);
        orPointcut.addArgument(other);
        orPointcut.setProject(this.project);
        return orPointcut;
    }

    protected IPointcut bitwiseNegate() {
        NotPointcut notPointcut = new NotPointcut(this.containerIdentifier, "not");
        notPointcut.addArgument(this);
        notPointcut.setProject(this.project);
        return notPointcut;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(" + String.valueOf(this.containerIdentifier) + ")\n");
        this.formatedString(sb, 2);
        return sb.toString();
    }

    protected void formatedString(StringBuilder sb, int indent) {
        sb.append(this.getPointcutDebugName());
        this.elements.formattedString(sb, indent + 2);
        sb.append("\n");
    }

    static String spaces(int indent) {
        StringBuilder sb = new StringBuilder(indent + 2);
        int i = 0;
        while (i < indent) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    protected Map<String, Object> namedArgumentsAsMap() {
        return this.elements.asMap();
    }

    protected Collection<?> ensureCollection(Object toMatch) {
        if (toMatch == null) {
            return null;
        }
        return toMatch instanceof Collection ? (Set<Object>)toMatch : Collections.singleton(toMatch);
    }
}

