/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codehaus.groovy.eclipse.dsl.pointcuts.AbstractPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.groovy.eclipse.dsl.pointcuts.IPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.PointcutVerificationException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jdt.groovy.search.VariableScope;

public class EnclosingCallNamePointcut
extends AbstractPointcut {
    public EnclosingCallNamePointcut(IStorage containerIdentifier, String pointcutName) {
        super(containerIdentifier, pointcutName);
    }

    @Override
    public Collection<?> matches(GroovyDSLDContext pattern, Object toMatch) {
        List enclosing = pattern.getCurrentScope().getAllEnclosingMethodCallExpressions();
        if (enclosing == null || enclosing.isEmpty()) {
            return null;
        }
        Function<VariableScope.CallAndType, String> toResult = cat -> cat.call.getMethodAsString();
        Object firstArgument = this.getFirstArgument();
        if (firstArgument == null) {
            return enclosing.stream().map(toResult).collect(Collectors.toList());
        }
        if (firstArgument instanceof String) {
            ArrayList<String> results = null;
            for (VariableScope.CallAndType callAndType : enclosing) {
                if (!firstArgument.equals(callAndType.call.getMethodAsString())) continue;
                if (results == null) {
                    results = new ArrayList<String>(4);
                }
                results.add(toResult.apply(callAndType));
            }
            return results;
        }
        return this.matchOnPointcutArgument((IPointcut)firstArgument, pattern, enclosing.stream().map(toResult).collect(Collectors.toList()));
    }

    @Override
    public void verify() throws PointcutVerificationException {
        String hasOneOrNoArgs = this.hasOneOrNoArgs();
        if (hasOneOrNoArgs != null) {
            throw new PointcutVerificationException(hasOneOrNoArgs, this);
        }
        super.verify();
    }
}

