/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts.impl;

import java.util.Collection;
import java.util.Collections;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.eclipse.dsl.pointcuts.AbstractPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.groovy.eclipse.dsl.pointcuts.IPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.PointcutVerificationException;
import org.codehaus.groovy.transform.trait.Traits;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;

public class EnclosingClassPointcut
extends AbstractPointcut {
    public EnclosingClassPointcut(IStorage containerIdentifier, String pointcutName) {
        super(containerIdentifier, pointcutName);
    }

    @Override
    public void verify() throws PointcutVerificationException {
        String hasOneOrNoArgs = this.hasOneOrNoArgs();
        if (hasOneOrNoArgs != null) {
            throw new PointcutVerificationException(hasOneOrNoArgs, this);
        }
        super.verify();
    }

    @Override
    public Collection<?> matches(GroovyDSLDContext pattern, Object toMatch) {
        ClassNode enclosingType = pattern.getCurrentScope().getEnclosingTypeDeclaration();
        if (enclosingType == null || GroovyUtils.isScript((ClassNode)enclosingType) || enclosingType.isAnnotationDefinition() || enclosingType.isInterface() && !Traits.isTrait((ClassNode)enclosingType)) {
            return null;
        }
        String enclosingTypeName = enclosingType.getName();
        Object firstArgument = this.getFirstArgument();
        if (firstArgument instanceof String) {
            if (enclosingTypeName.equals(firstArgument)) {
                return Collections.singleton(enclosingType);
            }
        } else if (firstArgument instanceof Class) {
            if (enclosingTypeName.equals(((Class)firstArgument).getName())) {
                return Collections.singleton(enclosingType);
            }
        } else {
            if (firstArgument instanceof IPointcut) {
                return this.matchOnPointcutArgument((IPointcut)firstArgument, pattern, Collections.singleton(enclosingType));
            }
            System.err.println("First argument to enclosingClass pointcut was not a Class, String, or IPointcut: " + String.valueOf(firstArgument));
        }
        return null;
    }
}

