/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts.impl;

import java.util.List;
import java.util.stream.Collectors;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.eclipse.dsl.pointcuts.impl.FindASTPointcut;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;

public class FindCtorPointcut
extends FindASTPointcut<ConstructorNode> {
    public FindCtorPointcut(IStorage containerIdentifier, String pointcutName) {
        super(containerIdentifier, pointcutName, ConstructorNode.class, ClassNode::getDeclaredConstructors, ctor -> {
            List paramTypes = GroovyUtils.getParameterTypes((Parameter[])ctor.getParameters());
            return paramTypes.stream().map(FindCtorPointcut::getSimpleTypeName).map(name -> name.substring(name.lastIndexOf(36) + 1)).collect(Collectors.joining(","));
        });
    }

    private static String getSimpleTypeName(ClassNode type) {
        int dims = 0;
        while (type.isArray()) {
            ++dims;
            type = type.getComponentType();
        }
        Object name = type.getNameWithoutPackage();
        while (dims > 0) {
            name = (String)name + "[]";
            --dims;
        }
        return name;
    }
}

