/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.groovy.eclipse.dsl.pointcuts.impl.FilteringPointcut;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jdt.groovy.search.VariableScope;

public class SubTypePointcut
extends FilteringPointcut<ClassNode> {
    private Map<ClassNode, Set<ClassNode>> cachedHierarchies = new WeakHashMap<ClassNode, Set<ClassNode>>();

    public SubTypePointcut(IStorage containerIdentifier, String pointcutName) {
        super(containerIdentifier, pointcutName, ClassNode.class);
    }

    @Override
    protected Collection<ClassNode> explodeObject(Object object) {
        if (object instanceof Collection) {
            LinkedHashSet<ClassNode> classes = new LinkedHashSet<ClassNode>();
            for (Object item : (Collection)object) {
                if (!(item instanceof ClassNode)) continue;
                classes.addAll(this.getSuperTypes((ClassNode)item));
            }
            return classes;
        }
        if (object instanceof ClassNode) {
            return new LinkedHashSet<ClassNode>(this.getSuperTypes((ClassNode)object));
        }
        return null;
    }

    @Override
    protected ClassNode filterObject(ClassNode result, GroovyDSLDContext context, String firstArgAsString) {
        if (firstArgAsString == null || firstArgAsString.equals(result.getName())) {
            return result;
        }
        return null;
    }

    private Set<ClassNode> getSuperTypes(ClassNode type) {
        return this.cachedHierarchies.computeIfAbsent(type, t -> {
            LinkedHashSet superTypes = new LinkedHashSet();
            VariableScope.createTypeHierarchy((ClassNode)type, superTypes, (boolean)false);
            return superTypes;
        });
    }
}

