/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts.impl;

import java.util.Collection;
import java.util.Collections;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.groovy.eclipse.dsl.pointcuts.impl.FilteringPointcut;
import org.eclipse.core.resources.IStorage;

public class TypePointcut
extends FilteringPointcut<ClassNode> {
    public TypePointcut(IStorage containerIdentifier, String pointcutName) {
        super(containerIdentifier, pointcutName, ClassNode.class);
    }

    @Override
    protected Collection<ClassNode> explodeObject(Object toMatch) {
        ClassNode type = null;
        if (toMatch instanceof ClassNode) {
            type = (ClassNode)toMatch;
        } else if (toMatch instanceof FieldNode) {
            type = ((FieldNode)toMatch).getType();
        } else if (toMatch instanceof MethodNode) {
            type = ((MethodNode)toMatch).getReturnType();
        } else if (toMatch instanceof PropertyNode) {
            type = ((PropertyNode)toMatch).getType();
        } else if (toMatch instanceof Variable) {
            type = ((Variable)toMatch).getType();
        } else if (toMatch instanceof BinaryExpression && ((BinaryExpression)toMatch).getLeftExpression() instanceof Variable && ((BinaryExpression)toMatch).getOperation().isA(1100)) {
            type = ((Variable)((BinaryExpression)toMatch).getLeftExpression()).getType();
        } else if (toMatch instanceof Expression) {
            type = ((Expression)toMatch).getType();
        }
        if (type != null) {
            return Collections.singleton(type);
        }
        return null;
    }

    @Override
    protected ClassNode filterObject(ClassNode result, GroovyDSLDContext context, String firstArgAsString) {
        return firstArgAsString == null || firstArgAsString.equals(result.getName()) ? result : null;
    }
}

